/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.matrix;

import com.aliasi.matrix.DenseVector;
import com.aliasi.matrix.SparseFloatVector;
import com.aliasi.matrix.TaxicabDistance;
import com.aliasi.test.unit.Asserts;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.util.HashMap;
import junit.framework.Assert;
import org.junit.Test;

public class TaxicabDistanceTest {
    @Test
    public void testOne() throws IOException, ClassNotFoundException {
        DenseVector v1 = new DenseVector(new double[]{1.0, 2.0});
        DenseVector v2 = new DenseVector(new double[]{3.0, 1.0});
        HashMap<Integer, Double> map1 = new HashMap<Integer, Double>();
        map1.put(0, 1.0);
        map1.put(1, 2.0);
        HashMap<Integer, Double> map2 = new HashMap<Integer, Double>();
        map2.put(0, 3.0);
        map2.put(1, 1.0);
        SparseFloatVector sv1 = new SparseFloatVector(map1);
        SparseFloatVector sv2 = new SparseFloatVector(map2);
        Assert.assertEquals((double)3.0, (double)TaxicabDistance.DISTANCE.distance(v1, v2), (double)1.0E-4);
        Assert.assertEquals((double)3.0, (double)TaxicabDistance.DISTANCE.distance(sv1, sv2), (double)1.0E-4);
        Assert.assertEquals((double)3.0, (double)TaxicabDistance.DISTANCE.distance(v1, sv2), (double)1.0E-4);
        Assert.assertEquals((double)3.0, (double)TaxicabDistance.DISTANCE.distance(sv1, v2), (double)1.0E-4);
        TaxicabDistance d2 = (TaxicabDistance)AbstractExternalizable.serializeDeserialize(TaxicabDistance.DISTANCE);
        Assert.assertEquals((double)3.0, (double)d2.distance(v1, v2), (double)1.0E-4);
        Assert.assertEquals((double)3.0, (double)d2.distance(v1, sv2), (double)1.0E-4);
        Assert.assertEquals((double)3.0, (double)d2.distance(sv1, v2), (double)1.0E-4);
        Assert.assertEquals((double)3.0, (double)d2.distance(sv1, sv2), (double)1.0E-4);
        HashMap<Integer, Double> map3 = new HashMap<Integer, Double>();
        map3.put(1, -1.0);
        SparseFloatVector vA = new SparseFloatVector(map3, 5);
        HashMap<Integer, Double> map4 = new HashMap<Integer, Double>();
        map4.put(2, 1.0);
        SparseFloatVector vB = new SparseFloatVector(map4, 5);
        Assert.assertEquals((double)2.0, (double)d2.distance(vA, vB), (double)1.0E-4);
        Assert.assertEquals((double)2.0, (double)d2.distance(vB, vA), (double)1.0E-4);
        DenseVector vC = new DenseVector(new double[]{0.0, 1.0, 0.0, 0.0, 0.0});
        DenseVector vD = new DenseVector(new double[]{0.0, 0.0, 1.0, 0.0, 0.0});
        Assert.assertEquals((double)2.0, (double)d2.distance(vA, vD), (double)1.0E-4);
        Assert.assertEquals((double)2.0, (double)d2.distance(vD, vA), (double)1.0E-4);
        Assert.assertEquals((double)2.0, (double)d2.distance(vC, vB), (double)1.0E-4);
        Assert.assertEquals((double)2.0, (double)d2.distance(vB, vC), (double)1.0E-4);
    }

    @Test
    public void testExs() {
        DenseVector v1 = new DenseVector(new double[]{0.0, 1.0});
        DenseVector v2 = new DenseVector(new double[]{2.0});
        try {
            TaxicabDistance.DISTANCE.distance(v1, v2);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
    }
}

