/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.sentences;

import com.aliasi.sentences.HeuristicSentenceModel;
import com.aliasi.sentences.SentenceModel;
import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class HeuristicSentenceModelTest {
    @Test
    public void testBoundaries() {
        this.assertBoundaries(new String[0], new String[]{""}, new int[0]);
        this.assertBoundaries(new String[]{"a"}, new String[]{"", ""}, new int[]{0});
        this.assertBoundaries(new String[]{".", "a"}, new String[]{"", "", ""}, new int[]{1});
        this.assertBoundaries(new String[]{"a", "."}, new String[]{"", "", ""}, new int[0]);
        this.assertBoundaries(new String[]{".", "a", "."}, new String[]{"", "", "", ""}, new int[0]);
        this.assertBoundaries(new String[]{"X", "a"}, new String[]{"", "", ""}, new int[0]);
        this.assertBoundaries(new String[]{"a", "1"}, new String[]{"", "", ""}, new int[0]);
        this.assertBoundaries(new String[]{"X", "a", "."}, new String[]{"", "", "", ""}, new int[0]);
        this.assertBoundaries(new String[]{".", "a", "1"}, new String[]{"", "", "", ""}, new int[0]);
        this.assertBoundaries(new String[]{"a", "zoo"}, new String[]{"", "", ""}, new int[0]);
        this.assertBoundaries(new String[]{"a", "Zoo"}, new String[]{"", "", ""}, new int[0]);
        this.assertBoundaries(new String[]{".", "a", "zoo"}, new String[]{"", "", "", ""}, new int[0]);
        this.assertBoundaries(new String[]{".", "a", "Zoo"}, new String[]{"", "", "", ""}, new int[0]);
    }

    private void assertBoundaries(String[] tokens, String[] whitespaces, int[] boundaries) {
        HashSet<String> stops = new HashSet<String>();
        stops.add("A");
        stops.add("B");
        stops.add("a");
        stops.add("b");
        HashSet<String> badPrevious = new HashSet<String>();
        badPrevious.add("X");
        badPrevious.add("Y");
        HashSet<String> badFollowing = new HashSet<String>();
        badFollowing.add("1");
        badFollowing.add("2");
        HeuristicSentenceModel model = new HeuristicSentenceModel(stops, badPrevious, badFollowing);
        this.assertBoundaries(model, tokens, whitespaces, 0, tokens.length, boundaries);
        Object[] tokens2 = new String[tokens.length + 10];
        Object[] whitespaces2 = new String[whitespaces.length + 10];
        Arrays.fill(tokens2, "boo");
        Arrays.fill(whitespaces2, " ");
        for (int i = 0; i < tokens.length; ++i) {
            tokens2[i + 5] = tokens[i];
            whitespaces2[i + 5] = whitespaces[i];
        }
        int[] boundaries2 = new int[boundaries.length];
        for (int i = 0; i < boundaries.length; ++i) {
            boundaries2[i] = boundaries[i] + 5;
        }
        this.assertBoundaries(model, (String[])tokens2, (String[])whitespaces2, 5, tokens.length, boundaries2);
    }

    private void assertBoundaries(SentenceModel model, String[] tokens, String[] whitespaces, int start, int length, int[] boundaries) {
        HashSet<Integer> boundariesSet = new HashSet<Integer>();
        model.boundaryIndices(tokens, whitespaces, start, length, boundariesSet);
        junit.framework.Assert.assertEquals((int)boundaries.length, (int)boundariesSet.size());
        for (int i = 0; i < boundaries.length; ++i) {
            junit.framework.Assert.assertTrue((boolean)boundariesSet.contains(boundaries[i]));
        }
        if (start == 0 && length == tokens.length) {
            int[] boundariesDerived = model.boundaryIndices(tokens, whitespaces);
            Assert.assertArrayEquals((int[])boundaries, (int[])boundariesDerived);
        }
    }
}

