/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.spell;

import com.aliasi.lm.NGramProcessLM;
import com.aliasi.spell.CompiledSpellChecker;
import com.aliasi.spell.FixedWeightEditDistance;
import com.aliasi.spell.TrainSpellChecker;
import com.aliasi.spell.WeightedEditDistance;
import com.aliasi.tokenizer.IndoEuropeanTokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.ScoredObject;
import java.io.IOException;
import java.util.Iterator;
import junit.framework.Assert;
import org.junit.Test;

public class SpellCheckerTest {
    @Test
    public void testCaser() throws ClassNotFoundException, IOException {
        NGramProcessLM lm = new NGramProcessLM(6, 256, 6.0);
        WeightedEditDistance caseRestoring = CompiledSpellChecker.CASE_RESTORING;
        Assert.assertEquals((double)0.0, (double)caseRestoring.substituteWeight('a', 'A'), (double)5.0E-4);
        Assert.assertEquals((double)0.0, (double)caseRestoring.substituteWeight('A', 'a'), (double)5.0E-4);
        Assert.assertEquals((double)0.0, (double)caseRestoring.matchWeight('a'), (double)5.0E-4);
        Assert.assertTrue((caseRestoring.substituteWeight('a', 'B') == Double.NEGATIVE_INFINITY ? 1 : 0) != 0);
        Assert.assertTrue((caseRestoring.transposeWeight('a', 'b') == Double.NEGATIVE_INFINITY ? 1 : 0) != 0);
        Assert.assertTrue((caseRestoring.insertWeight('a') == Double.NEGATIVE_INFINITY ? 1 : 0) != 0);
        Assert.assertTrue((caseRestoring.deleteWeight('a') == Double.NEGATIVE_INFINITY ? 1 : 0) != 0);
        TrainSpellChecker trainer = new TrainSpellChecker(lm, CompiledSpellChecker.CASE_RESTORING, IndoEuropeanTokenizerFactory.INSTANCE);
        for (int i = 0; i < 1000; ++i) {
            trainer.handle("abc DEF gHiJk lm");
        }
        CompiledSpellChecker speller = (CompiledSpellChecker)AbstractExternalizable.compile(trainer);
        this.assertSpell(speller, "abc def", "abc DEF");
        this.assertSpell(speller, "DEF ghijk", "DEF gHiJk");
        this.assertSpell(speller, "def ghijk", "DEF gHiJk");
    }

    @Test
    public void testTrain() throws ClassNotFoundException, IOException {
        NGramProcessLM lm = new NGramProcessLM(6, 256, 6.0);
        TrainSpellChecker trainer = new TrainSpellChecker(lm, new FixedWeightEditDistance(0.0, -3.0, -2.0, -1.0, -1.0), IndoEuropeanTokenizerFactory.INSTANCE);
        for (int i = 0; i < 1000; ++i) {
            trainer.handle("abracadabra abracadabra abracadabra");
        }
        CompiledSpellChecker speller = (CompiledSpellChecker)AbstractExternalizable.compile(trainer);
        this.assertSpell(speller, "abracadabra", "abracadabra");
        this.assertSpell(speller, "ibracadabra", "abracadabra");
        this.assertSpell(speller, "abricadabra", "abracadabra");
        this.assertSpell(speller, "abracadabri", "abracadabra");
        this.assertSpell(speller, "iabracadabra", "abracadabra");
        this.assertSpell(speller, "abraicadabra", "abracadabra");
        this.assertSpell(speller, "abracadabrai", "abracadabra");
        this.assertSpell(speller, "bracadabra", "abracadabra");
        this.assertSpell(speller, "abracdabra", "abracadabra");
        this.assertSpell(speller, "abracadabr", "abracadabra");
        this.assertSpell(speller, "baracadabra", "abracadabra");
        this.assertSpell(speller, "abraacdabra", "abracadabra");
        this.assertSpell(speller, "abracadabar", "abracadabra");
        this.assertSpell(speller, "abra cadabra", "abracadabra");
        this.assertSpell(speller, "abracadabraabracadabra", "abracadabra abracadabra");
    }

    @Test
    public void testTokenizer() throws ClassNotFoundException, IOException {
        NGramProcessLM lm = new NGramProcessLM(6, 256, 6.0);
        WeightedEditDistance tokenizingDistance = CompiledSpellChecker.TOKENIZING;
        Assert.assertEquals((double)0.0, (double)tokenizingDistance.insertWeight(' '), (double)5.0E-4);
        Assert.assertEquals((double)0.0, (double)tokenizingDistance.matchWeight(' '), (double)5.0E-4);
        Assert.assertTrue((Double.NEGATIVE_INFINITY == tokenizingDistance.insertWeight('a') ? 1 : 0) != 0);
        Assert.assertTrue((Double.NEGATIVE_INFINITY == tokenizingDistance.deleteWeight('a') ? 1 : 0) != 0);
        Assert.assertTrue((Double.NEGATIVE_INFINITY == tokenizingDistance.transposeWeight('a', 'b') ? 1 : 0) != 0);
        Assert.assertTrue((Double.NEGATIVE_INFINITY == tokenizingDistance.substituteWeight('a', 'b') ? 1 : 0) != 0);
        TrainSpellChecker trainer = new TrainSpellChecker(lm, tokenizingDistance, IndoEuropeanTokenizerFactory.INSTANCE);
        for (int i = 0; i < 20; ++i) {
            trainer.handle("abc def ghijk lm");
        }
        CompiledSpellChecker speller = (CompiledSpellChecker)AbstractExternalizable.compile(trainer);
        this.assertSpell(speller, "abcdef", "abc def");
        this.assertSpell(speller, "ghijklm", "ghijk lm");
        this.assertSpell(speller, "abclm", "abc lm");
        this.assertSpell(speller, "ghief", "ghief");
        this.assertSpell(speller, "boo abcdef", "boo abc def");
    }

    @Test
    public void testNBest() throws ClassNotFoundException, IOException {
        int i;
        NGramProcessLM lm = new NGramProcessLM(6, 256, 6.0);
        TrainSpellChecker trainer = new TrainSpellChecker(lm, new FixedWeightEditDistance(0.0, -3.0, -2.0, -1.0, -1.0), IndoEuropeanTokenizerFactory.INSTANCE);
        for (i = 0; i < 1000; ++i) {
            trainer.handle("abc");
            trainer.handle("abd");
            trainer.handle("abe");
            trainer.handle("abf");
        }
        for (i = 0; i < 10; ++i) {
            trainer.handle("abc");
        }
        CompiledSpellChecker speller = (CompiledSpellChecker)AbstractExternalizable.compile(trainer);
        this.assertSpell(speller, "abx", "abc");
    }

    void assertSpell(CompiledSpellChecker sc, String in, String expected) {
        sc.setNBest(32);
        String found = sc.didYouMean(in);
        Assert.assertEquals((String)("\n  FAILED TEST\n     In=/" + in + "/\n     Expected=/" + expected + "/\n     Found=/" + found + "/\n"), (String)expected, (String)found);
        Iterator<ScoredObject<String>> nBestIt = sc.didYouMeanNBest(in);
        Assert.assertTrue((boolean)nBestIt.hasNext());
        ScoredObject<String> so = nBestIt.next();
        Assert.assertEquals((String)so.getObject().toString(), (String)expected);
    }
}

