/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.stats;

import com.aliasi.stats.AbstractDiscreteDistribution;
import com.aliasi.util.Math;
import junit.framework.Assert;
import org.junit.Test;

public class AbstractDiscreteDistributionTest {
    @Test
    public void testOne() {
        Distro distro = new Distro();
        Assert.assertEquals((long)1L, (long)distro.minOutcome());
        Assert.assertEquals((long)10L, (long)distro.maxOutcome());
        Assert.assertEquals((double)0.5, (double)distro.cumulativeProbabilityLess(5L), (double)0.001);
        Assert.assertEquals((double)0.0, (double)distro.cumulativeProbabilityLess(0L), (double)0.001);
        Assert.assertEquals((double)1.0, (double)distro.cumulativeProbabilityLess(10L), (double)0.001);
        Assert.assertEquals((double)1.0, (double)distro.cumulativeProbabilityLess(20L), (double)0.001);
        Assert.assertEquals((double)0.5, (double)distro.cumulativeProbabilityGreater(6L), (double)0.001);
        Assert.assertEquals((double)0.0, (double)distro.cumulativeProbabilityGreater(11L), (double)0.001);
        Assert.assertEquals((double)1.0, (double)distro.cumulativeProbabilityGreater(0L), (double)0.001);
        Assert.assertEquals((double)1.0, (double)distro.cumulativeProbabilityGreater(-20L), (double)0.001);
        Assert.assertEquals((double)0.5, (double)distro.cumulativeProbability(1L, 5L), (double)0.001);
        Assert.assertEquals((double)0.5, (double)distro.cumulativeProbability(-3L, 5L), (double)0.001);
        Assert.assertEquals((double)0.5, (double)distro.cumulativeProbability(-3L, 5L), (double)0.001);
        Assert.assertEquals((double)0.0, (double)distro.cumulativeProbability(-3L, -4L), (double)0.001);
        Assert.assertEquals((double)1.0, (double)distro.cumulativeProbability(-3L, 15L), (double)0.001);
        Assert.assertEquals((double)1.0, (double)distro.cumulativeProbability(1L, 10L), (double)0.001);
        Assert.assertEquals((double)0.1, (double)distro.probability(1L), (double)1.0E-4);
        Assert.assertEquals((double)0.1, (double)distro.probability(5L), (double)1.0E-4);
        Assert.assertEquals((double)0.1, (double)distro.probability(10L), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)distro.probability(17L), (double)1.0E-4);
        Assert.assertEquals((double)Math.log2(0.1), (double)distro.log2Probability(1L), (double)1.0E-4);
        Assert.assertEquals((double)Math.log2(0.1), (double)distro.log2Probability(5L), (double)1.0E-4);
        Assert.assertEquals((double)Math.log2(0.1), (double)distro.log2Probability(10L), (double)1.0E-4);
        Assert.assertEquals((double)Math.log2(0.0), (double)distro.log2Probability(17L), (double)1.0E-4);
        double mean = 5.5;
        double variance = 0.0;
        for (int i = 1; i <= 10; ++i) {
            double diff = mean - (double)i;
            variance += diff * diff;
        }
        Assert.assertEquals((double)mean, (double)distro.mean(), (double)1.0E-4);
        Assert.assertEquals((double)(variance /= 10.0), (double)distro.variance(), (double)1.0E-4);
        double entropy = 0.0;
        for (int i = 1; i <= 10; ++i) {
            entropy += -distro.probability(i) * distro.log2Probability(i);
        }
        Assert.assertEquals((double)entropy, (double)distro.entropy(), (double)1.0E-4);
    }

    public static class Distro
    extends AbstractDiscreteDistribution {
        @Override
        public double probability(long outcome) {
            if (outcome < 1L || outcome > 10L) {
                return 0.0;
            }
            return 0.1;
        }

        @Override
        public long minOutcome() {
            return 1L;
        }

        @Override
        public long maxOutcome() {
            return 10L;
        }
    }
}

