/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.stats;

import com.aliasi.stats.BernoulliDistribution;
import com.aliasi.stats.BernoulliEstimator;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import junit.framework.Assert;
import org.junit.Test;

public class BernoulliEstimatorTest {
    @Test
    public void testOne() throws IOException, ClassNotFoundException {
        BernoulliEstimator coin = new BernoulliEstimator();
        coin.train(true);
        coin.train(true);
        coin.train(false);
        coin.train(true, 1);
        coin.train(true, 5);
        coin.train(false, 7);
        BernoulliEstimatorTest.assertFairCoin(coin);
        Assert.assertTrue((boolean)(AbstractExternalizable.compile(coin) instanceof BernoulliDistribution));
        coin.train(true, 8);
        Assert.assertEquals((double)0.6666666666666666, (double)coin.successProbability(), (double)1.0E-4);
        Assert.assertEquals((double)0.3333333333333333, (double)coin.probability(0L), (double)1.0E-4);
    }

    static void assertFairCoin(BernoulliDistribution coin) {
        Assert.assertEquals((long)0L, (long)coin.minOutcome());
        Assert.assertEquals((long)1L, (long)coin.maxOutcome());
        Assert.assertEquals((int)2, (int)coin.numDimensions());
        Assert.assertEquals((String)"failure", (String)coin.label(0L));
        Assert.assertEquals((String)"success", (String)coin.label(1L));
        Assert.assertEquals((double)0.5, (double)coin.successProbability(), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)coin.probability(0L), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)coin.probability(1L), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)coin.cumulativeProbabilityLess(-1L), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)coin.cumulativeProbabilityLess(0L), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)coin.cumulativeProbabilityLess(1L), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)coin.cumulativeProbabilityLess(2L), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)coin.cumulativeProbabilityGreater(-1L), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)coin.cumulativeProbabilityGreater(0L), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)coin.cumulativeProbabilityGreater(1L), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)coin.cumulativeProbabilityGreater(2L), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)coin.cumulativeProbability(-2L, -1L), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)coin.cumulativeProbability(3L, 120L), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)coin.cumulativeProbability(-1L, 0L), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)coin.cumulativeProbability(1L, 1L), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)coin.cumulativeProbability(1L, 15L), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)coin.cumulativeProbability(0L, 1L), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)coin.cumulativeProbability(0L, 14L), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)coin.cumulativeProbability(-12L, 14L), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)coin.entropy(), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)coin.mean(), (double)1.0E-4);
        Assert.assertEquals((double)0.25, (double)coin.variance(), (double)1.0E-4);
    }
}

