/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.stats;

import com.aliasi.stats.MultinomialDistribution;
import com.aliasi.stats.MultivariateConstant;
import com.aliasi.util.Math;
import junit.framework.Assert;
import org.junit.Test;

public class MultinomialDistributionTest {
    @Test
    public void testBenford() {
        MultivariateConstant benfordsDistro = new MultivariateConstant(new double[]{0.301, 0.176, 0.125, 0.097, 0.079, 0.067, 0.058, 0.051, 0.046});
        MultinomialDistribution distro = new MultinomialDistribution(benfordsDistro);
        int[] samples = new int[]{111, 60, 46, 29, 26, 22, 21, 20, 20};
        double chiSquared = distro.chiSquared(samples);
        Assert.assertEquals((double)2.49, (double)chiSquared, (double)0.05);
    }

    @Test
    public void testOne() {
        MultivariateConstant basis = new MultivariateConstant(new long[]{1L, 2L, 3L});
        Assert.assertEquals((int)3, (int)basis.numDimensions());
        MultinomialDistribution distro = new MultinomialDistribution(basis);
        Assert.assertEquals((int)3, (int)distro.numDimensions());
        Assert.assertEquals((Object)basis, (Object)distro.basisDistribution());
        int[] outcomes = new int[]{3, 2, 1};
        double log2Coeff = MultinomialDistribution.log2MultinomialCoefficient(outcomes);
        double log2Prob = log2Coeff + 3.0 * Math.log2(0.16666666666666666) + 2.0 * Math.log2(0.3333333333333333) + 1.0 * Math.log2(0.5);
        Assert.assertEquals((double)log2Prob, (double)distro.log2Probability(outcomes), (double)1.0E-4);
    }

    @Test
    public void testTwo() {
        MultivariateConstant basis = new MultivariateConstant(new long[]{0L, 1L, 1L});
        MultinomialDistribution distro = new MultinomialDistribution(basis);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)distro.log2Probability(new int[]{1, 1, 0}), (double)1.0E-4);
    }

    @Test
    public void testChiSquared() {
        MultivariateConstant basis = new MultivariateConstant(new long[]{1L, 2L, 3L});
        MultinomialDistribution distro = new MultinomialDistribution(basis);
        int[] testSample = new int[]{3, 2, 1};
        double expected = 5.333333333333333;
        Assert.assertEquals((double)expected, (double)distro.chiSquared(testSample), (double)1.0E-4);
    }

    @Test
    public void testCoeff() {
        int[] counts = new int[]{0};
        Assert.assertEquals((double)0.0, (double)MultinomialDistribution.log2MultinomialCoefficient(counts), (double)1.0E-4);
        counts = new int[]{1};
        Assert.assertEquals((double)0.0, (double)MultinomialDistribution.log2MultinomialCoefficient(counts), (double)1.0E-4);
        counts = new int[]{1, 1};
        Assert.assertEquals((double)Math.log2(2.0), (double)MultinomialDistribution.log2MultinomialCoefficient(counts), (double)1.0E-4);
        counts = new int[]{2, 0};
        Assert.assertEquals((double)Math.log2(1.0), (double)MultinomialDistribution.log2MultinomialCoefficient(counts), (double)1.0E-4);
        counts = new int[]{5, 5, 5};
        Assert.assertEquals((double)(Math.log2Factorial(15L) - 3.0 * Math.log2Factorial(5L)), (double)MultinomialDistribution.log2MultinomialCoefficient(counts), (double)1.0E-4);
    }
}

