/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.stats;

import com.aliasi.stats.MultivariateConstant;
import com.aliasi.stats.MultivariateDistribution;
import com.aliasi.stats.MultivariateEstimator;
import com.aliasi.util.Math;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import org.junit.Test;

public class MultivariateEstimatorTest {
    @Test
    public void testDecrement() {
        MultivariateEstimator me = new MultivariateEstimator();
        me.train("a", 2L);
        me.train("b", 3L);
        me.train("c", 2L);
        me.train("c", 2L);
        Assert.assertEquals((long)4L, (long)me.getCount("c"));
        Assert.assertEquals((double)0.4444444444444444, (double)me.probability(me.outcome("c")), (double)0.001);
        me.resetCount("c");
        Assert.assertEquals((long)0L, (long)me.getCount("c"));
        Assert.assertEquals((double)0.6, (double)me.probability(me.outcome("b")), (double)1.0E-4);
    }

    @Test
    public void testOne() throws ClassNotFoundException, IOException {
        MultivariateEstimator me = new MultivariateEstimator();
        for (int i = 0; i < 10; ++i) {
            me.train(Integer.toString(i), 1L);
        }
        this.assertDistro(me);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(bytesOut);
        me.compileTo(objOut);
        byte[] bytes = bytesOut.toByteArray();
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes);
        ObjectInputStream objIn = new ObjectInputStream(bytesIn);
        MultivariateConstant mvc = (MultivariateConstant)objIn.readObject();
        this.assertDistro(mvc);
    }

    public void assertDistro(MultivariateDistribution distro) {
        Assert.assertEquals((long)0L, (long)distro.minOutcome());
        Assert.assertEquals((long)9L, (long)distro.maxOutcome());
        Assert.assertEquals((int)10, (int)distro.numDimensions());
        Assert.assertEquals((double)0.5, (double)distro.cumulativeProbabilityLess(4L), (double)0.001);
        Assert.assertEquals((double)0.0, (double)distro.cumulativeProbabilityLess(-1L), (double)0.001);
        Assert.assertEquals((double)1.0, (double)distro.cumulativeProbabilityLess(9L), (double)0.001);
        Assert.assertEquals((double)1.0, (double)distro.cumulativeProbabilityLess(20L), (double)0.001);
        Assert.assertEquals((double)0.5, (double)distro.cumulativeProbabilityGreater(5L), (double)0.001);
        Assert.assertEquals((double)0.0, (double)distro.cumulativeProbabilityGreater(10L), (double)0.001);
        Assert.assertEquals((double)1.0, (double)distro.cumulativeProbabilityGreater(0L), (double)0.001);
        Assert.assertEquals((double)1.0, (double)distro.cumulativeProbabilityGreater(-20L), (double)0.001);
        Assert.assertEquals((double)0.5, (double)distro.cumulativeProbability(1L, 5L), (double)0.001);
        Assert.assertEquals((double)0.5, (double)distro.cumulativeProbability(-3L, 4L), (double)0.001);
        Assert.assertEquals((double)0.5, (double)distro.cumulativeProbability(-3L, 4L), (double)0.001);
        Assert.assertEquals((double)0.0, (double)distro.cumulativeProbability(-3L, -4L), (double)0.001);
        Assert.assertEquals((double)1.0, (double)distro.cumulativeProbability(-3L, 15L), (double)0.001);
        Assert.assertEquals((double)1.0, (double)distro.cumulativeProbability(0L, 9L), (double)0.001);
        Assert.assertEquals((double)0.1, (double)distro.probability(0L), (double)1.0E-4);
        Assert.assertEquals((double)0.1, (double)distro.probability(5L), (double)1.0E-4);
        Assert.assertEquals((double)0.1, (double)distro.probability(9L), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)distro.probability(17L), (double)1.0E-4);
        Assert.assertEquals((double)Math.log2(0.1), (double)distro.log2Probability(0L), (double)1.0E-4);
        Assert.assertEquals((double)Math.log2(0.1), (double)distro.log2Probability(5L), (double)1.0E-4);
        Assert.assertEquals((double)Math.log2(0.1), (double)distro.log2Probability(9L), (double)1.0E-4);
        Assert.assertEquals((double)Math.log2(0.0), (double)distro.log2Probability(17L), (double)1.0E-4);
        double mean = 4.5;
        double variance = 0.0;
        for (int i = 0; i < 10; ++i) {
            double diff = mean - (double)i;
            variance += diff * diff;
        }
        Assert.assertEquals((double)mean, (double)distro.mean(), (double)1.0E-4);
        Assert.assertEquals((double)(variance /= 10.0), (double)distro.variance(), (double)1.0E-4);
        double entropy = 0.0;
        for (int i = 0; i <= 9; ++i) {
            entropy += -distro.probability(i) * distro.log2Probability(i);
        }
        Assert.assertEquals((double)entropy, (double)distro.entropy(), (double)1.0E-4);
    }
}

