/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.suffixarray;

import com.aliasi.suffixarray.CharSuffixArray;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class CharSuffixArrayTest {
    @Test
    public void testAbracadabra() {
        String cs = "abracadabra";
        CharSuffixArray csa = new CharSuffixArray(cs);
        junit.framework.Assert.assertEquals((String)cs, (String)csa.text());
        int[] expected_sa = new int[]{10, 7, 0, 3, 5, 8, 1, 4, 6, 9, 2};
        junit.framework.Assert.assertEquals((int)expected_sa.length, (int)csa.suffixArrayLength());
        for (int i = 0; i < expected_sa.length; ++i) {
            junit.framework.Assert.assertEquals((int)expected_sa[i], (int)csa.suffixArray(i));
        }
        List<int[]> prefixMatches = csa.prefixMatches(3);
        Assert.assertArrayEquals((int[])new int[]{1, 3}, (int[])prefixMatches.get(0));
        Assert.assertArrayEquals((int[])new int[]{5, 7}, (int[])prefixMatches.get(1));
        junit.framework.Assert.assertEquals((int)2, (int)prefixMatches.size());
    }

    @Test
    public void testEmpty() {
        String cs = "";
        CharSuffixArray csa = new CharSuffixArray(cs);
        junit.framework.Assert.assertEquals((String)cs, (String)csa.text());
        junit.framework.Assert.assertEquals((int)0, (int)csa.suffixArrayLength());
        junit.framework.Assert.assertEquals((int)0, (int)csa.prefixMatches(3).size());
    }

    @Test
    public void testBound() {
        String cs = "abababccc";
        CharSuffixArray csa = new CharSuffixArray(cs, 1);
        List<int[]> prefixMatches = csa.prefixMatches(1);
        junit.framework.Assert.assertEquals((int)3, (int)prefixMatches.size());
        for (int[] match : prefixMatches) {
            junit.framework.Assert.assertEquals((int)3, (int)(match[1] - match[0]));
            for (int j = match[0] + 1; j < match[1]; ++j) {
                junit.framework.Assert.assertEquals((char)cs.charAt(csa.suffixArray(j - 1)), (char)cs.charAt(csa.suffixArray(j)));
            }
        }
    }
}

