/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.symbol;

import com.aliasi.symbol.SymbolTable;
import com.aliasi.symbol.SymbolTableCompiler;
import com.aliasi.test.unit.symbol.AbstractSymbolTable;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.io.Serializable;
import junit.framework.Assert;
import org.junit.Test;

public class SymbolTableCompilerTest
extends AbstractSymbolTable {
    @Test
    public void testSerializable() throws IOException {
        String[] symbols = new String[]{"b", "a", "c", "x", "abc", "ab", "z"};
        SymbolTable table = SymbolTableCompiler.asSymbolTable(symbols);
        SymbolTable table2 = (SymbolTable)AbstractExternalizable.serializeDeserialize((Serializable)((Object)table));
        Assert.assertEquals((int)table.numSymbols(), (int)table2.numSymbols());
        for (int i = 0; i < table.numSymbols(); ++i) {
            Assert.assertEquals((String)table.idToSymbol(i), (String)table2.idToSymbol(i));
            Assert.assertEquals((int)table.symbolToID(table.idToSymbol(i)), (int)table2.symbolToID(table2.idToSymbol(i)));
        }
    }

    @Test
    public void testStaticFactoryOrder() {
        String[] symbols = new String[]{"b", "a"};
        SymbolTable table = SymbolTableCompiler.asSymbolTable(symbols);
        Assert.assertEquals((int)0, (int)table.symbolToID("b"));
        Assert.assertEquals((int)1, (int)table.symbolToID("a"));
    }

    @Test
    public void testStaticConstruction() {
        String[] symbols = new String[]{"a", "b"};
        SymbolTable table = SymbolTableCompiler.asSymbolTable(symbols);
        Assert.assertEquals((int)2, (int)table.numSymbols());
        Assert.assertEquals((String)"a", (String)table.idToSymbol(0));
        Assert.assertEquals((String)"b", (String)table.idToSymbol(1));
        Assert.assertEquals((int)0, (int)table.symbolToID("a"));
        Assert.assertEquals((int)1, (int)table.symbolToID("b"));
        Assert.assertEquals((int)-1, (int)table.symbolToID("c"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testStaticDuplicateException() {
        SymbolTableCompiler.asSymbolTable(new String[]{"a", "b", "a"});
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testStaticImmutableException1() {
        SymbolTableCompiler.asSymbolTable(new String[]{"a", "b"}).clear();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testStaticImmutableException2() {
        SymbolTableCompiler.asSymbolTable(new String[]{"foo"}).removeSymbol("foo");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testStaticImmutableException3() {
        SymbolTableCompiler.asSymbolTable(new String[]{"foo"}).getOrAddSymbol("foo");
    }

    @Test
    public void testCompilation() throws ClassNotFoundException, IOException {
        SymbolTableCompiler compiler = new SymbolTableCompiler();
        compiler.addSymbol("a");
        compiler.addSymbol("bb");
        SymbolTable compiledTable = (SymbolTable)AbstractExternalizable.compile(compiler);
        this.assertTwoElementTable(compiledTable);
        this.assertTwoElementTable(compiler);
    }
}

