/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.tag;

import com.aliasi.classify.BaseClassifier;
import com.aliasi.classify.Classification;
import com.aliasi.classify.Classified;
import com.aliasi.corpus.Corpus;
import com.aliasi.corpus.ListCorpus;
import com.aliasi.corpus.ObjectHandler;
import com.aliasi.tag.ClassifierTagger;
import com.aliasi.tag.Tagging;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class ClassifierTaggerTest {
    @Test
    public void testToClassified() throws IOException {
        List<Integer> toks1 = Arrays.asList(1, 2, 3);
        List<String> tags1 = Arrays.asList("a", "b", "c");
        Tagging<Integer> tagging1 = new Tagging<Integer>(toks1, tags1);
        List<Integer> toks2 = Arrays.asList(4, 5);
        List<String> tags2 = Arrays.asList("d", "e");
        Tagging<Integer> tagging2 = new Tagging<Integer>(toks2, tags2);
        List<Integer> toks3 = Arrays.asList(6);
        List<String> tags3 = Arrays.asList("f");
        Tagging<Integer> tagging3 = new Tagging<Integer>(toks3, tags3);
        ListCorpus taggingCorpus = new ListCorpus();
        taggingCorpus.addTrain(tagging1);
        taggingCorpus.addTrain(tagging2);
        taggingCorpus.addTest(tagging3);
        Assert.assertEquals((int)2, (int)taggingCorpus.trainCases().size());
        Assert.assertEquals((int)1, (int)taggingCorpus.testCases().size());
        Corpus stateCorpus = ClassifierTagger.toClassifiedCorpus(taggingCorpus);
        CounterHandler handler = new CounterHandler();
        stateCorpus.visitTrain(handler);
        Assert.assertEquals((int)5, (int)handler.mList.size());
        Assert.assertEquals((String)"a", (String)handler.mList.get(0).getClassification().bestCategory());
        Assert.assertEquals((String)"b", (String)handler.mList.get(1).getClassification().bestCategory());
        Assert.assertEquals((String)"c", (String)handler.mList.get(2).getClassification().bestCategory());
        Assert.assertEquals((String)"d", (String)handler.mList.get(3).getClassification().bestCategory());
        Assert.assertEquals((String)"e", (String)handler.mList.get(4).getClassification().bestCategory());
        Assert.assertEquals((int)0, (int)handler.mList.get(0).getObject().position());
        Assert.assertEquals((int)1, (int)handler.mList.get(1).getObject().position());
        Assert.assertEquals((int)2, (int)handler.mList.get(2).getObject().position());
        Assert.assertEquals((int)0, (int)handler.mList.get(3).getObject().position());
        Assert.assertEquals((int)1, (int)handler.mList.get(4).getObject().position());
        Assert.assertEquals(Arrays.asList(1, 2, 3), handler.mList.get(0).getObject().tokens());
        Assert.assertEquals(Arrays.asList(1, 2, 3), handler.mList.get(1).getObject().tokens());
        Assert.assertEquals(Arrays.asList(1, 2, 3), handler.mList.get(2).getObject().tokens());
        Assert.assertEquals(Arrays.asList(4, 5), handler.mList.get(3).getObject().tokens());
        Assert.assertEquals(Arrays.asList(4, 5), handler.mList.get(4).getObject().tokens());
        Assert.assertEquals(Arrays.asList(new Object[0]), handler.mList.get(0).getObject().tags());
        Assert.assertEquals(Arrays.asList("a"), handler.mList.get(1).getObject().tags());
        Assert.assertEquals(Arrays.asList("a", "b"), handler.mList.get(2).getObject().tags());
        Assert.assertEquals(Arrays.asList(new Object[0]), handler.mList.get(3).getObject().tags());
        Assert.assertEquals(Arrays.asList("d"), handler.mList.get(4).getObject().tags());
        CounterHandler handler2 = new CounterHandler();
        stateCorpus.visitTest(handler2);
        Assert.assertEquals((int)1, (int)handler2.mList.size());
        Assert.assertEquals((String)"f", (String)handler2.mList.get(0).getClassification().bestCategory());
        Assert.assertEquals((int)0, (int)handler2.mList.get(0).getObject().position());
        Assert.assertEquals(Arrays.asList(6), handler2.mList.get(0).getObject().tokens());
        Assert.assertEquals(Arrays.asList(new Object[0]), handler2.mList.get(0).getObject().tags());
    }

    @Test
    public void testClassify() {
        MockClassifier classifier = new MockClassifier();
        ClassifierTagger<Integer> tagger = new ClassifierTagger<Integer>(classifier);
        Assert.assertEquals((Object)classifier, tagger.classifier());
        Tagging<Integer> tagging = tagger.tag(Arrays.asList(new Integer[0]));
        Assert.assertEquals((int)0, (int)tagging.size());
    }

    static class MockClassifier
    implements BaseClassifier<ClassifierTagger.State<Integer>> {
        MockClassifier() {
        }

        @Override
        public Classification classify(ClassifierTagger.State<Integer> state) {
            int i;
            StringBuilder sb = new StringBuilder();
            sb.append(state.position());
            for (i = 0; i < state.numTokens(); ++i) {
                sb.append(state.tag(i));
            }
            for (i = 0; i < state.position(); ++i) {
                sb.append(state.token(i));
            }
            return new Classification(sb.toString());
        }
    }

    static class CounterHandler
    implements ObjectHandler<Classified<ClassifierTagger.State<Integer>>> {
        List<Classified<ClassifierTagger.State<Integer>>> mList = new ArrayList<Classified<ClassifierTagger.State<Integer>>>();
        int mCount = 0;

        CounterHandler() {
        }

        @Override
        public void handle(Classified<ClassifierTagger.State<Integer>> c) {
            this.mList.add(c);
        }
    }
}

