/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.tag;

import com.aliasi.tag.StringTagging;
import java.util.Arrays;
import junit.framework.Assert;
import org.junit.Test;

public class StringTaggingTest {
    @Test(expected=IllegalArgumentException.class)
    public void testConsExc1() {
        new StringTagging(Arrays.asList("one", "two", "three"), Arrays.asList("one", "two"), (CharSequence)"a b c", new int[]{0, 2, 4}, new int[]{2, 3, 5});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConsExc2() {
        new StringTagging(Arrays.asList("one", "two", "three"), Arrays.asList("one", "two", "three"), (CharSequence)"a b c", new int[]{0, 2}, new int[]{2, 3, 5});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConsExc3() {
        new StringTagging(Arrays.asList("one", "two", "three"), Arrays.asList("one", "two", "three"), (CharSequence)"a b c", new int[]{0, 2, 4}, new int[]{2, 3});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConsExc4() {
        new StringTagging(Arrays.asList("one", "two", "three"), Arrays.asList("one", "two", "three"), (CharSequence)"a b c", new int[]{-1, 2, 4}, new int[]{2, 3, 5});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConsExc5() {
        new StringTagging(Arrays.asList("one", "two", "three"), Arrays.asList("one", "two", "three"), (CharSequence)"a b c", new int[]{2, 1, 4}, new int[]{2, 3, 5});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConsExc6() {
        new StringTagging(Arrays.asList("one", "two", "three"), Arrays.asList("one", "two", "three"), (CharSequence)"a b c", new int[]{1, 3, 4}, new int[]{2, 2, 5});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConsExc7() {
        new StringTagging(Arrays.asList("one", "two", "three"), Arrays.asList("one", "two", "three"), (CharSequence)"a b c", new int[]{0, 2, 4}, new int[]{1, 3, 6});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConsExc8() {
        new StringTagging(Arrays.asList("one", "two", "three"), Arrays.asList("one", "two", "three"), (CharSequence)"a b c", new int[]{2, 1, 4}, new int[]{3, 2, 5});
    }

    @Test
    public void testConsOk() {
        StringTagging tagging = new StringTagging(Arrays.asList("1", "2", "3"), Arrays.asList("a", "b", "c"), (CharSequence)"A B C", new int[]{0, 2, 4}, new int[]{1, 3, 5});
        Assert.assertEquals((int)3, (int)tagging.size());
        Assert.assertEquals(Arrays.asList("1", "2", "3"), tagging.tokens());
        Assert.assertEquals(Arrays.asList("a", "b", "c"), tagging.tags());
        Assert.assertEquals((String)"a", (String)tagging.tag(0));
        Assert.assertEquals((String)"b", (String)tagging.tag(1));
        Assert.assertEquals((String)"c", (String)tagging.tag(2));
        Assert.assertEquals((String)"1", (String)((String)tagging.token(0)));
        Assert.assertEquals((String)"2", (String)((String)tagging.token(1)));
        Assert.assertEquals((String)"3", (String)((String)tagging.token(2)));
        Assert.assertEquals((String)"A B C", (String)tagging.characters());
        Assert.assertEquals((String)"A", (String)tagging.rawToken(0));
        Assert.assertEquals((String)"B", (String)tagging.rawToken(1));
        Assert.assertEquals((String)"C", (String)tagging.rawToken(2));
        Assert.assertEquals((int)0, (int)tagging.tokenStart(0));
        Assert.assertEquals((int)2, (int)tagging.tokenStart(1));
        Assert.assertEquals((int)4, (int)tagging.tokenStart(2));
        Assert.assertEquals((int)1, (int)tagging.tokenEnd(0));
        Assert.assertEquals((int)3, (int)tagging.tokenEnd(1));
        Assert.assertEquals((int)5, (int)tagging.tokenEnd(2));
        Assert.assertNotNull((Object)tagging.toString());
    }

    @Test
    public void testBoundaryCons() {
        StringTagging tagging = new StringTagging(Arrays.asList("1", "2", "3"), Arrays.asList("a", "b", "c"), (CharSequence)"", new int[]{0, 0, 0}, new int[]{0, 0, 0});
        Assert.assertEquals((int)3, (int)tagging.size());
        Assert.assertEquals(Arrays.asList("1", "2", "3"), tagging.tokens());
        Assert.assertEquals(Arrays.asList("a", "b", "c"), tagging.tags());
        Assert.assertEquals((String)"a", (String)tagging.tag(0));
        Assert.assertEquals((String)"b", (String)tagging.tag(1));
        Assert.assertEquals((String)"c", (String)tagging.tag(2));
        Assert.assertEquals((String)"1", (String)((String)tagging.token(0)));
        Assert.assertEquals((String)"2", (String)((String)tagging.token(1)));
        Assert.assertEquals((String)"3", (String)((String)tagging.token(2)));
        Assert.assertEquals((String)"", (String)tagging.characters());
        Assert.assertEquals((String)"", (String)tagging.rawToken(0));
        Assert.assertEquals((String)"", (String)tagging.rawToken(1));
        Assert.assertEquals((String)"", (String)tagging.rawToken(2));
        Assert.assertEquals((int)0, (int)tagging.tokenStart(0));
        Assert.assertEquals((int)0, (int)tagging.tokenStart(1));
        Assert.assertEquals((int)0, (int)tagging.tokenStart(2));
        Assert.assertEquals((int)0, (int)tagging.tokenEnd(0));
        Assert.assertEquals((int)0, (int)tagging.tokenEnd(1));
        Assert.assertEquals((int)0, (int)tagging.tokenEnd(2));
        Assert.assertNotNull((Object)tagging.toString());
    }
}

