/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.tokenizer;

import com.aliasi.tokenizer.CharacterTokenizerFactory;
import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.io.Serializable;
import junit.framework.Assert;
import org.junit.Test;

public class CharacterTokenizerFactoryTest {
    @Test
    public void testPositions() {
        char[] cs = new char[]{'a', 'b', 'c', 'd', 'e'};
        Tokenizer tokenizer = CharacterTokenizerFactory.INSTANCE.tokenizer(cs, 1, 2);
        Assert.assertEquals((int)-1, (int)tokenizer.lastTokenStartPosition());
        Assert.assertEquals((int)-1, (int)tokenizer.lastTokenEndPosition());
        String t = tokenizer.nextToken();
        Assert.assertEquals((String)"b", (String)t);
        Assert.assertEquals((int)0, (int)tokenizer.lastTokenStartPosition());
        Assert.assertEquals((int)1, (int)tokenizer.lastTokenEndPosition());
        String t2 = tokenizer.nextToken();
        Assert.assertEquals((String)"c", (String)t2);
        Assert.assertEquals((int)1, (int)tokenizer.lastTokenStartPosition());
        Assert.assertEquals((int)2, (int)tokenizer.lastTokenEndPosition());
        String t3 = tokenizer.nextToken();
        Assert.assertNull((Object)t3);
        Assert.assertEquals((int)1, (int)tokenizer.lastTokenStartPosition());
        Assert.assertEquals((int)2, (int)tokenizer.lastTokenEndPosition());
        cs = new char[]{'a', 'b', ' ', 'c', ' '};
        tokenizer = CharacterTokenizerFactory.INSTANCE.tokenizer(cs, 0, cs.length);
        Assert.assertEquals((int)-1, (int)tokenizer.lastTokenStartPosition());
        Assert.assertEquals((int)-1, (int)tokenizer.lastTokenEndPosition());
        t = tokenizer.nextToken();
        Assert.assertEquals((String)"a", (String)t);
        Assert.assertEquals((int)0, (int)tokenizer.lastTokenStartPosition());
        Assert.assertEquals((int)1, (int)tokenizer.lastTokenEndPosition());
        t2 = tokenizer.nextToken();
        Assert.assertEquals((String)"b", (String)t2);
        Assert.assertEquals((int)1, (int)tokenizer.lastTokenStartPosition());
        Assert.assertEquals((int)2, (int)tokenizer.lastTokenEndPosition());
        t3 = tokenizer.nextToken();
        Assert.assertEquals((String)"c", (String)t3);
        Assert.assertEquals((int)3, (int)tokenizer.lastTokenStartPosition());
        Assert.assertEquals((int)4, (int)tokenizer.lastTokenEndPosition());
        tokenizer.nextWhitespace();
        Assert.assertEquals((int)3, (int)tokenizer.lastTokenStartPosition());
        Assert.assertEquals((int)4, (int)tokenizer.lastTokenEndPosition());
        Assert.assertNull((Object)tokenizer.nextToken());
        Assert.assertEquals((int)3, (int)tokenizer.lastTokenStartPosition());
        Assert.assertEquals((int)4, (int)tokenizer.lastTokenEndPosition());
    }

    @Test
    public void testTokenize() {
        this.assertTokenize("abc", new String[]{"a", "b", "c"});
        this.assertTokenize("", new String[0]);
    }

    void assertTokenize(String input, String[] tokens) {
        TokenizerFactory factory = CharacterTokenizerFactory.INSTANCE;
        Tokenizer tokenizer = factory.tokenizer(input.toCharArray(), 0, input.length());
        for (int i = 0; i < tokens.length; ++i) {
            Assert.assertEquals((String)"", (String)tokenizer.nextWhitespace());
            Assert.assertEquals((String)tokens[i], (String)tokenizer.nextToken());
        }
        Assert.assertEquals((String)"", (String)tokenizer.nextWhitespace());
        Assert.assertNull((Object)tokenizer.nextToken());
    }

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        TokenizerFactory factory = CharacterTokenizerFactory.INSTANCE;
        TokenizerFactory compiledFactory = (TokenizerFactory)AbstractExternalizable.serializeDeserialize((Serializable)((Object)factory));
        Assert.assertEquals((Object)CharacterTokenizerFactory.INSTANCE, (Object)compiledFactory);
    }
}

