/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.tokenizer;

import com.aliasi.tokenizer.IndoEuropeanTokenCategorizer;
import com.aliasi.tokenizer.TokenCategorizer;
import com.aliasi.util.AbstractExternalizable;
import junit.framework.Assert;
import org.junit.Test;

public class IndoEuropeanTokenCategorizerTest {
    @Test
    public void testCategorize() throws Exception {
        this.assertTokenCategory("", "NULL-TOK");
        this.assertTokenCategory("1", "1-DIG");
        this.assertTokenCategory("22", "2-DIG");
        this.assertTokenCategory("333", "3-DIG");
        this.assertTokenCategory("4444", "4-DIG");
        this.assertTokenCategory("666666", "5+-DIG");
        this.assertTokenCategory("a55", "DIG-LET");
        this.assertTokenCategory("5a", "DIG-LET");
        this.assertTokenCategory("5a66-bb", "DIG-LET");
        this.assertTokenCategory("$%^&*()hdjh76jdj", "DIG-LET");
        this.assertTokenCategory("555-1212", "DIG--");
        this.assertTokenCategory("5/12/12", "DIG-/");
        this.assertTokenCategory("5/12/12.", "DIG-/");
        this.assertTokenCategory("500,000", "DIG-,");
        this.assertTokenCategory("500,000.97", "DIG-,");
        this.assertTokenCategory("500.000", "DIG-.");
        this.assertTokenCategory("A", "1-LET-UP");
        this.assertTokenCategory("B", "1-LET-UP");
        this.assertTokenCategory("ABC", "LET-UP");
        this.assertTokenCategory("Abc", "LET-CAP");
        this.assertTokenCategory("fooBar", "LET-MIX");
        this.assertTokenCategory("FooBar", "LET-MIX");
        this.assertTokenCategory(";:..", "PUNC-");
        this.assertTokenCategory(";:..", "PUNC-");
        this.assertTokenCategory(").", "OTHER");
        this.assertTokenCategory("^&*(a", "OTHER");
    }

    private void assertTokenCategory(String token, String category) throws Exception {
        IndoEuropeanTokenCategorizer categorizer = IndoEuropeanTokenCategorizer.CATEGORIZER;
        Assert.assertEquals((String)("Expected category(" + token + ")=" + category + "; but was category=" + categorizer.categorize(token)), (String)category, (String)categorizer.categorize(token));
        TokenCategorizer c_categorizer = (TokenCategorizer)AbstractExternalizable.compile(categorizer);
        Assert.assertEquals((String)("Expected category(" + token + ")=" + category + "; but was category=" + c_categorizer.categorize(token)), (String)category, (String)c_categorizer.categorize(token));
    }
}

