/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.tokenizer;

import com.aliasi.test.unit.tokenizer.IndoEuropean;
import com.aliasi.tokenizer.IndoEuropeanTokenizerFactory;
import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class IndoEuropeanTokenizerFactoryTest
extends IndoEuropean {
    @Test
    public void testBeginEndsPeriods() {
        String in = "Mr. John Jones ran to Washington.";
        Tokenizer tokenizer = IndoEuropeanTokenizerFactory.INSTANCE.tokenizer(in.toCharArray(), 0, in.length());
        String token = tokenizer.nextToken();
        junit.framework.Assert.assertEquals((String)"Mr", (String)token);
        junit.framework.Assert.assertEquals((int)0, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)2, (int)tokenizer.lastTokenEndPosition());
        token = tokenizer.nextToken();
        junit.framework.Assert.assertEquals((String)".", (String)token);
        junit.framework.Assert.assertEquals((int)2, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)3, (int)tokenizer.lastTokenEndPosition());
        token = tokenizer.nextToken();
        junit.framework.Assert.assertEquals((String)"John", (String)token);
        junit.framework.Assert.assertEquals((int)4, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)8, (int)tokenizer.lastTokenEndPosition());
        token = tokenizer.nextToken();
        junit.framework.Assert.assertEquals((String)"Jones", (String)token);
        junit.framework.Assert.assertEquals((int)9, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)14, (int)tokenizer.lastTokenEndPosition());
        token = tokenizer.nextToken();
        junit.framework.Assert.assertEquals((String)"ran", (String)token);
        junit.framework.Assert.assertEquals((int)15, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)18, (int)tokenizer.lastTokenEndPosition());
        token = tokenizer.nextToken();
        junit.framework.Assert.assertEquals((String)"to", (String)token);
        junit.framework.Assert.assertEquals((int)19, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)21, (int)tokenizer.lastTokenEndPosition());
        token = tokenizer.nextToken();
        junit.framework.Assert.assertEquals((String)"Washington", (String)token);
        junit.framework.Assert.assertEquals((int)22, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)32, (int)tokenizer.lastTokenEndPosition());
        token = tokenizer.nextToken();
        junit.framework.Assert.assertEquals((String)".", (String)token);
        junit.framework.Assert.assertEquals((int)32, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)33, (int)tokenizer.lastTokenEndPosition());
        token = tokenizer.nextToken();
        junit.framework.Assert.assertNull((Object)token);
    }

    @Test
    public void testBeginEnds() {
        String s = "foo bar 1.1 baz.";
        char[] cs = "foo bar 1.1 baz.".toCharArray();
        Tokenizer tokenizer = IndoEuropeanTokenizerFactory.INSTANCE.tokenizer(cs, 3, cs.length - 3);
        junit.framework.Assert.assertEquals((int)-1, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)-1, (int)tokenizer.lastTokenEndPosition());
        String token = tokenizer.nextToken();
        junit.framework.Assert.assertEquals((String)"bar", (String)token);
        junit.framework.Assert.assertEquals((int)1, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)4, (int)tokenizer.lastTokenEndPosition());
        tokenizer.nextWhitespace();
        junit.framework.Assert.assertEquals((int)1, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)4, (int)tokenizer.lastTokenEndPosition());
        token = tokenizer.nextToken();
        junit.framework.Assert.assertEquals((String)"1.1", (String)token);
        junit.framework.Assert.assertEquals((int)5, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)8, (int)tokenizer.lastTokenEndPosition());
        tokenizer.nextWhitespace();
        junit.framework.Assert.assertEquals((int)5, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)8, (int)tokenizer.lastTokenEndPosition());
        token = tokenizer.nextToken();
        junit.framework.Assert.assertEquals((String)"baz", (String)token);
        junit.framework.Assert.assertEquals((int)9, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)12, (int)tokenizer.lastTokenEndPosition());
        token = tokenizer.nextToken();
        junit.framework.Assert.assertEquals((String)".", (String)token);
        junit.framework.Assert.assertEquals((int)12, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)13, (int)tokenizer.lastTokenEndPosition());
        tokenizer.nextWhitespace();
        junit.framework.Assert.assertNull((Object)tokenizer.nextToken());
        junit.framework.Assert.assertEquals((int)12, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)13, (int)tokenizer.lastTokenEndPosition());
    }

    @Override
    protected void assertTokenize(String input, String[] whitespaces, String[] tokens, int[] starts) {
        IndoEuropeanTokenizerFactory factory = IndoEuropeanTokenizerFactory.INSTANCE;
        Assert.assertArrayEquals((Object[])tokens, (Object[])factory.tokenizer(input.toCharArray(), 0, input.length()).tokenize());
        Tokenizer tokenizer = factory.tokenizer(input.toCharArray(), 0, input.length());
        for (int i = 0; i < starts.length; ++i) {
            String whitespace = tokenizer.nextWhitespace();
            String token = tokenizer.nextToken();
            junit.framework.Assert.assertEquals((String)"Whitespace mismatch", (String)whitespace, (String)whitespaces[i]);
            junit.framework.Assert.assertEquals((String)"Token mismatch", (String)token, (String)tokens[i]);
            junit.framework.Assert.assertEquals((String)"Last token start position mismatch", (int)tokenizer.lastTokenStartPosition(), (int)starts[i]);
        }
        junit.framework.Assert.assertEquals((String)"Final whitespace mismatch", (String)whitespaces[whitespaces.length - 1], (String)tokenizer.nextWhitespace());
        junit.framework.Assert.assertNull((String)"Should return final null", (Object)tokenizer.nextToken());
    }

    @Test
    public void testSerialization() throws ClassNotFoundException, IOException {
        IndoEuropeanTokenizerFactory factory = IndoEuropeanTokenizerFactory.INSTANCE;
        TokenizerFactory compiledFactory = (TokenizerFactory)AbstractExternalizable.serializeDeserialize(factory);
        junit.framework.Assert.assertTrue((IndoEuropeanTokenizerFactory.INSTANCE == compiledFactory ? 1 : 0) != 0);
    }
}

