/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.tokenizer;

import com.aliasi.tokenizer.NGramTokenizerFactory;
import com.aliasi.tokenizer.Tokenizer;
import org.junit.Assert;
import org.junit.Test;

public class NGramTokenizerFactoryTest {
    @Test
    public void testStartEnd() {
        String s = "abc defg b";
        char[] cs = s.toCharArray();
        Tokenizer tokenizer = new NGramTokenizerFactory(1, 2).tokenizer(cs, 2, 5);
        junit.framework.Assert.assertEquals((int)-1, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)-1, (int)tokenizer.lastTokenEndPosition());
        String token = tokenizer.nextToken();
        junit.framework.Assert.assertEquals((String)"c", (String)token);
        junit.framework.Assert.assertEquals((int)0, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)1, (int)tokenizer.lastTokenEndPosition());
        tokenizer.nextWhitespace();
        junit.framework.Assert.assertEquals((int)0, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)1, (int)tokenizer.lastTokenEndPosition());
        token = tokenizer.nextToken();
        junit.framework.Assert.assertEquals((String)" ", (String)token);
        junit.framework.Assert.assertEquals((int)1, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)2, (int)tokenizer.lastTokenEndPosition());
        tokenizer.nextWhitespace();
        junit.framework.Assert.assertEquals((int)1, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)2, (int)tokenizer.lastTokenEndPosition());
        junit.framework.Assert.assertEquals((String)"d", (String)tokenizer.nextToken());
        junit.framework.Assert.assertEquals((String)"e", (String)tokenizer.nextToken());
        junit.framework.Assert.assertEquals((int)3, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)4, (int)tokenizer.lastTokenEndPosition());
        junit.framework.Assert.assertEquals((String)"f", (String)tokenizer.nextToken());
        junit.framework.Assert.assertEquals((int)4, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)5, (int)tokenizer.lastTokenEndPosition());
        junit.framework.Assert.assertEquals((String)"c ", (String)tokenizer.nextToken());
        junit.framework.Assert.assertEquals((int)0, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)2, (int)tokenizer.lastTokenEndPosition());
        junit.framework.Assert.assertEquals((String)" d", (String)tokenizer.nextToken());
        junit.framework.Assert.assertEquals((int)1, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)3, (int)tokenizer.lastTokenEndPosition());
        junit.framework.Assert.assertEquals((String)"de", (String)tokenizer.nextToken());
        junit.framework.Assert.assertEquals((int)2, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)4, (int)tokenizer.lastTokenEndPosition());
        junit.framework.Assert.assertEquals((String)"ef", (String)tokenizer.nextToken());
        junit.framework.Assert.assertEquals((int)3, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)5, (int)tokenizer.lastTokenEndPosition());
        junit.framework.Assert.assertNull((Object)tokenizer.nextToken());
        junit.framework.Assert.assertEquals((int)3, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)5, (int)tokenizer.lastTokenEndPosition());
        tokenizer.nextWhitespace();
        junit.framework.Assert.assertEquals((int)3, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((int)5, (int)tokenizer.lastTokenEndPosition());
    }

    @Test
    public void test1() {
        char[] cs = "abcd".toCharArray();
        Assert.assertArrayEquals((Object[])new String[]{"ab", "bc", "cd", "abc", "bcd"}, (Object[])new NGramTokenizerFactory(2, 3).tokenizer(cs, 0, cs.length).tokenize());
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c", "d"}, (Object[])new NGramTokenizerFactory(1, 1).tokenizer(cs, 0, cs.length).tokenize());
    }

    @Test(expected=IllegalArgumentException.class)
    public void test1Exc() {
        new NGramTokenizerFactory(3, 2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test1ExcB() {
        new NGramTokenizerFactory(-2, 0);
    }

    @Test
    public void test2() {
        char[] cs = "he".toCharArray();
        Assert.assertArrayEquals((Object[])new String[]{"he"}, (Object[])new NGramTokenizerFactory(2, 4).tokenizer(cs, 0, cs.length).tokenize());
    }

    @Test
    public void test3() {
        char[] cs = "abcd".toCharArray();
        Tokenizer tokenizer = new NGramTokenizerFactory(2, 3).tokenizer(cs, 0, cs.length);
        junit.framework.Assert.assertEquals((int)-1, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((String)"ab", (String)tokenizer.nextToken());
        junit.framework.Assert.assertEquals((int)0, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((String)"bc", (String)tokenizer.nextToken());
        junit.framework.Assert.assertEquals((int)1, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((String)"cd", (String)tokenizer.nextToken());
        junit.framework.Assert.assertEquals((int)2, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((String)"abc", (String)tokenizer.nextToken());
        junit.framework.Assert.assertEquals((int)0, (int)tokenizer.lastTokenStartPosition());
        junit.framework.Assert.assertEquals((String)"bcd", (String)tokenizer.nextToken());
        junit.framework.Assert.assertEquals((int)1, (int)tokenizer.lastTokenStartPosition());
    }
}

