/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.tokenizer;

import com.aliasi.test.unit.Asserts;
import com.aliasi.test.unit.tokenizer.TokenizerTest;
import com.aliasi.tokenizer.IndoEuropeanTokenizerFactory;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.tokenizer.WhitespaceNormTokenizerFactory;
import org.junit.Test;

public class WhitespaceNormTokenizerFactoryTest {
    @Test
    public void testFactory() {
        IndoEuropeanTokenizerFactory ieFactory = IndoEuropeanTokenizerFactory.INSTANCE;
        WhitespaceNormTokenizerFactory factory = new WhitespaceNormTokenizerFactory(ieFactory);
        TokenizerTest.assertFactory((TokenizerFactory)factory, "", new String[0], new String[]{""});
        TokenizerTest.assertFactory((TokenizerFactory)factory, "a", new String[]{"a"}, new String[]{"", ""});
        TokenizerTest.assertFactory((TokenizerFactory)factory, "\n\na   \n", new String[]{"a"}, new String[]{" ", " "});
        TokenizerTest.assertFactory((TokenizerFactory)factory, " a bb\nc\n", new String[]{"a", "bb", "c"}, new String[]{" ", " ", " ", " "});
    }

    @Test
    public void testNotSerializable() {
        WhitespaceNormTokenizerFactory unserializable = new WhitespaceNormTokenizerFactory(TokenizerTest.UNSERIALIZABLE_FACTORY);
        Asserts.assertNotSerializable(unserializable);
    }
}

