/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.util;

import com.aliasi.test.unit.Asserts;
import com.aliasi.util.CompactHashSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class CompactHashSetTest {
    @Test
    public void testConstruct() {
        new CompactHashSet(1);
        new CompactHashSet(2);
        new CompactHashSet(3);
        new CompactHashSet(4);
        new CompactHashSet(912);
        new CompactHashSet(15485863);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstruxNeg() {
        new CompactHashSet(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstrux0() {
        new CompactHashSet(0);
    }

    @Test(expected=OutOfMemoryError.class)
    public void testConstruxTooBig() {
        new CompactHashSet(Integer.MAX_VALUE);
    }

    @Test
    public void testZeroSize() {
        CompactHashSet<String> set = new CompactHashSet<String>(1);
        CompactHashSetTest.assertSetEquals(new HashSet<String>(), set);
    }

    @Test
    public void test1Element() {
        Set<String> xSet = CompactHashSetTest.hashSet("foo");
        CompactHashSet<String> ySet = new CompactHashSet<String>(15);
        ySet.add("foo");
        CompactHashSetTest.assertSetEquals(xSet, ySet);
        CompactHashSet<String> ySet2 = new CompactHashSet<String>(1);
        ySet2.add("foo");
        CompactHashSetTest.assertSetEquals(xSet, ySet2);
    }

    @Test
    public void test2Elements15() {
        Set<String> xSet = CompactHashSetTest.hashSet("foo", "bar");
        CompactHashSet<String> ySet = new CompactHashSet<String>(15);
        ySet.addAll(xSet);
        CompactHashSetTest.assertSetEquals(xSet, ySet);
    }

    @Test
    public void testSimp() {
        CompactHashSet<String> ySet = new CompactHashSet<String>(1);
        junit.framework.Assert.assertTrue((boolean)ySet.add("foo"));
        junit.framework.Assert.assertTrue((boolean)ySet.add("bar"));
    }

    @Test
    public void test2Elements1() {
        Set<String> xSet = CompactHashSetTest.hashSet("bing", "badkdki3lkawelkfj");
        CompactHashSet<String> ySet = new CompactHashSet<String>(1);
        junit.framework.Assert.assertTrue((boolean)ySet.add("bing"));
        junit.framework.Assert.assertEquals((int)1, (int)ySet.size());
        junit.framework.Assert.assertFalse((boolean)ySet.add("bing"));
        junit.framework.Assert.assertEquals((int)1, (int)ySet.size());
        junit.framework.Assert.assertTrue((boolean)ySet.add("badkdki3lkawelkfj"));
        junit.framework.Assert.assertEquals((int)2, (int)ySet.size());
        junit.framework.Assert.assertEquals(xSet, ySet);
    }

    @Test
    public void test5Elements1() {
        CompactHashSetTest.assertAdds(1, "abcd", "12345", "ZCXKDKD", "s", "yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy");
    }

    @Test
    public void testIteratorRemoves() {
        CompactHashSetTest.assertRemoves(1, "a");
    }

    static void assertAdds(int initialSize, String ... elts) {
        Random random = new Random(42L);
        String s1 = Arrays.asList(elts).toString();
        com.aliasi.util.Arrays.permute(elts, random);
        HashSet<String> xSet = new HashSet<String>();
        CompactHashSet<String> ySet = new CompactHashSet<String>(initialSize);
        for (String elt : elts) {
            junit.framework.Assert.assertTrue((boolean)xSet.add(elt));
            junit.framework.Assert.assertFalse((boolean)xSet.add(elt));
            junit.framework.Assert.assertTrue((boolean)ySet.add(elt));
            junit.framework.Assert.assertFalse((boolean)ySet.add(elt));
            Asserts.assertFullEquals("init=" + initialSize + " ", xSet, ySet);
        }
        com.aliasi.util.Arrays.permute(elts, random);
        String s2 = Arrays.asList(elts).toString();
        for (String elt : elts) {
            junit.framework.Assert.assertTrue((boolean)xSet.remove(elt));
            junit.framework.Assert.assertFalse((boolean)xSet.remove(elt));
            junit.framework.Assert.assertTrue((boolean)ySet.remove(elt));
            junit.framework.Assert.assertFalse((boolean)ySet.remove(elt));
            for (String x : xSet) {
                junit.framework.Assert.assertTrue((String)("\nx=" + x + "ySet=" + ySet + " s1=" + s1 + " s2=" + s2), (boolean)ySet.contains(x));
            }
            junit.framework.Assert.assertEquals(ySet, xSet);
            Asserts.assertFullEquals("init=" + initialSize + "\nxSet=" + xSet + "\nySet=" + ySet + "\ns1=" + s1 + "\ns2=" + s2 + "\n", xSet, ySet);
        }
    }

    static void assertRemoves(int initialSize, String ... elts) {
        Set<String> xSet = CompactHashSetTest.hashSet(elts);
        CompactHashSet<String> ySet = new CompactHashSet<String>(10);
        ySet.addAll(xSet);
        Iterator<String> it = ySet.iterator();
        for (int i = 0; i < elts.length; ++i) {
            junit.framework.Assert.assertEquals(xSet, ySet);
            CompactHashSetTest.assertIllegalRemoveState(it);
            String s = it.next();
            it.remove();
            xSet.remove(s);
        }
        CompactHashSetTest.assertIllegalRemoveState(it);
        CompactHashSetTest.assertSetEquals(xSet, ySet);
    }

    static void assertIllegalRemoveState(Iterator<String> it) {
        try {
            it.remove();
            junit.framework.Assert.fail();
        }
        catch (IllegalStateException e) {
            Asserts.succeed();
        }
    }

    static Set<String> hashSet(String ... xs) {
        HashSet<String> set = new HashSet<String>();
        for (String x : xs) {
            set.add(x);
        }
        return set;
    }

    static void assertSetEquals(Set<String> xSet, Set<String> ySet) {
        Asserts.assertFullEquals(xSet, ySet);
        Asserts.assertFullSerialization(ySet);
        junit.framework.Assert.assertEquals((int)xSet.size(), (int)ySet.size());
        junit.framework.Assert.assertEquals((boolean)xSet.isEmpty(), (boolean)ySet.isEmpty());
        Iterator<String> xIt = xSet.iterator();
        Iterator<String> yIt = ySet.iterator();
        HashSet<String> xItSet = new HashSet<String>();
        HashSet<String> yItSet = new HashSet<String>();
        while (xIt.hasNext()) {
            xItSet.add(xIt.next());
            yItSet.add(yIt.next());
        }
        junit.framework.Assert.assertFalse((boolean)yIt.hasNext());
        junit.framework.Assert.assertEquals(xItSet, yItSet);
        Object[] xsS = xSet.toArray(new String[0]);
        Object[] ysS = ySet.toArray(new String[ySet.size()]);
        Arrays.sort(xsS);
        Arrays.sort(ysS);
        Assert.assertArrayEquals((Object[])xsS, (Object[])ysS);
        Object[] xs = xSet.toArray();
        Object[] ys = ySet.toArray();
        Arrays.sort(xs);
        Arrays.sort(ys);
        Assert.assertArrayEquals((Object[])xs, (Object[])ys);
        for (String x : xSet) {
            junit.framework.Assert.assertTrue((boolean)ySet.contains(x));
        }
        for (String y : ySet) {
            junit.framework.Assert.assertTrue((boolean)xSet.contains(y));
        }
    }
}

