/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.util;

import com.aliasi.test.unit.Asserts;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.FastCache;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.junit.Test;

public class FastCacheTest {
    @Test
    public void testSerialize() throws IOException {
        FastCache<String, String> fc = new FastCache<String, String>(100, 0.5);
        fc.put("a", "b");
        fc.put("c", "d");
        Assert.assertEquals((int)2, (int)fc.size());
        Assert.assertEquals((String)"b", (String)((String)fc.get("a")));
        FastCache fc2 = (FastCache)AbstractExternalizable.serializeDeserialize(fc);
        Assert.assertEquals((int)2, (int)fc2.size());
        Assert.assertEquals((String)"b", (String)((String)fc.get("a")));
        Assert.assertFalse((boolean)fc.containsKey("d"));
    }

    @Test
    public void testClear() {
        FastCache<String, String> fc = new FastCache<String, String>(100, 0.5);
        fc.put("a", "b");
        fc.put("c", "d");
        Assert.assertEquals((int)2, (int)fc.size());
        Assert.assertEquals((String)"b", (String)((String)fc.get("a")));
        fc.clear();
        Assert.assertEquals((int)0, (int)fc.size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFastCacheException1() {
        new FastCache(0, 0.5);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFastCacheException2() {
        new FastCache(-10, 0.5);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFastCacheException3() {
        new FastCache(5, -0.5);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFastCacheException4() {
        new FastCache(5, Double.NaN);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFastCacheException5() {
        new FastCache(5, Double.POSITIVE_INFINITY);
    }

    @Test
    public void testOne() {
        long i;
        int numIts = 100000;
        FastCache<Long, int[]> cache = new FastCache<Long, int[]>(5000000, 1.0);
        for (i = 0L; i < (long)numIts; ++i) {
            cache.put(i, new int[(int)(i % 10L)]);
        }
        for (i = 0L; i < (long)numIts; ++i) {
            Assert.assertEquals((int)((int)(i % 10L)), (int)((int[])cache.get(i)).length);
        }
    }

    @Test
    public void testRecover() {
        int megabyte = 1000000;
        int numMegabytes = 100;
        FastCache<Integer, int[]> cache = new FastCache<Integer, int[]>(5000000, 1.0);
        for (int i = 0; i < numMegabytes; ++i) {
            cache.put(i, new int[megabyte]);
        }
        Asserts.succeed();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstruxExc1() {
        new FastCache(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstruxExc2() {
        new FastCache(1, 0.0);
    }

    @Test
    public void testPrune() {
        FastCache<Integer, Integer> cache = new FastCache<Integer, Integer>(150, 0.5);
        int max = 10000;
        for (int i = 0; i < max; ++i) {
            cache.put(i, i / 2);
        }
        Assert.assertTrue((cache.size() < 75 ? 1 : 0) != 0);
    }

    @Test
    public void testMulti() throws InterruptedException {
        int numThreads = 128;
        int numEntries = 32;
        ConcurrentHashMap<Integer, Integer> cache = new ConcurrentHashMap<Integer, Integer>();
        CacheTest[] cacheTests = new CacheTest[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            cacheTests[i] = new CacheTest(cache, numEntries);
        }
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(numThreads * 3 / 4);
        for (CacheTest testCache : cacheTests) {
            executor.execute(testCache);
        }
        executor.shutdown();
        executor.awaitTermination(30L, TimeUnit.SECONDS);
        for (int j = 0; j < numEntries; ++j) {
            Integer val = (Integer)cache.get(j);
            if (val == null) continue;
            Assert.assertEquals((Object)val, (Object)(j / 2));
        }
        int sumHits = 0;
        for (int i = 0; i < numThreads; ++i) {
            sumHits += cacheTests[i].mHits;
        }
        int misses = numThreads * numEntries - sumHits;
    }

    static class CacheTest
    implements Runnable {
        final Map<Integer, Integer> mCache;
        final int mNumEntries;
        int mHits = 0;

        CacheTest(Map<Integer, Integer> cache, int numEntries) {
            this.mCache = cache;
            this.mNumEntries = numEntries;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Random random = new Random();
            for (int j = 0; j < this.mNumEntries; ++j) {
                try {
                    Thread.sleep(random.nextInt(1));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (this.mCache.get(j) != null) {
                    CacheTest cacheTest = this;
                    synchronized (cacheTest) {
                        ++this.mHits;
                        continue;
                    }
                }
                this.mCache.put(j, j / 2);
            }
        }
    }
}

