/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.util;

import com.aliasi.test.unit.Asserts;
import com.aliasi.util.HardFastCache;
import junit.framework.Assert;
import org.junit.Test;

public class HardFastCacheTest {
    @Test
    public void testOne() {
        long i;
        int numIts = 100000;
        HardFastCache<Long, int[]> cache = new HardFastCache<Long, int[]>(5000000, 1.0);
        for (i = 0L; i < (long)numIts; ++i) {
            cache.put(i, new int[(int)(i % 10L)]);
        }
        for (i = 0L; i < (long)numIts; ++i) {
            Assert.assertEquals((int)((int)(i % 10L)), (int)((int[])cache.get(i)).length);
        }
    }

    @Test
    public void testRecover() {
        int megabyte = 1000000;
        int numMegabytes = 100;
        HardFastCache<Integer, int[]> cache = new HardFastCache<Integer, int[]>(5000000, 1.0);
        for (int i = 0; i < numMegabytes; ++i) {
            cache.put(i, new int[megabyte]);
        }
        Asserts.succeed();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstruxExc1() {
        new HardFastCache(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstruxExc2() {
        new HardFastCache(1, 0.0);
    }

    @Test
    public void testPrune() {
        HardFastCache<Integer, Integer> cache = new HardFastCache<Integer, Integer>(150, 0.5);
        int max = 10000;
        for (int i = 0; i < max; ++i) {
            cache.put(i, i / 2);
        }
        Assert.assertTrue((cache.size() < 75 ? 1 : 0) != 0);
    }

    @Test
    public void testMulti() throws InterruptedException {
        int i;
        HardFastCache cache = new HardFastCache(1000000, 1.0);
        int numThreads = 2;
        int numEntries = 8;
        Thread[] threads = new Thread[numThreads];
        for (i = 0; i < numThreads; ++i) {
            threads[i] = new Thread(new TestCache(cache, numEntries));
            threads[i].start();
        }
        for (i = 0; i < numThreads; ++i) {
            threads[i].join();
        }
        for (i = 0; i < numEntries; ++i) {
            Integer val = (Integer)cache.get(i);
            if (val == null) continue;
            Assert.assertEquals((Object)val, (Object)(i / 2));
        }
    }

    private static class TestCache
    implements Runnable {
        final HardFastCache mCache;
        int mNum;

        TestCache(HardFastCache cache, int num) {
            this.mCache = cache;
            this.mNum = num;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.mNum; ++i) {
                this.mCache.put(i, i / 2);
            }
        }
    }
}

