/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.util;

import com.aliasi.util.MinMaxHeap;
import com.aliasi.util.Scored;
import com.aliasi.util.ScoredObject;
import java.util.Arrays;
import java.util.Random;
import junit.framework.Assert;
import org.junit.Test;

public class MinMaxHeapTest {
    static final Random RANDOM = new Random();

    @Test
    public void testCreate() {
        MinMaxHeap heap = new MinMaxHeap(10);
        Assert.assertNotNull(heap);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSizeZero() {
        new MinMaxHeap(0);
    }

    @Test
    public void testOne() {
        MinMaxHeap<DoubleS> heap = new MinMaxHeap<DoubleS>(1);
        Assert.assertEquals((int)0, (int)heap.size());
        DoubleS d1 = new DoubleS(1.0);
        heap.add(d1);
        Assert.assertEquals((int)1, (int)heap.size());
        Assert.assertEquals((Object)d1, heap.peekMax());
        DoubleS d2 = new DoubleS(2.0);
        heap.add(d2);
        Assert.assertEquals((int)1, (int)heap.size());
        Assert.assertEquals((Object)d2, heap.peekMax());
        Assert.assertEquals((Object)d2, heap.peekMin());
        DoubleS d0 = new DoubleS(0.0);
        heap.add(d0);
        Assert.assertEquals((int)1, (int)heap.size());
        Assert.assertEquals((Object)d2, heap.peekMin());
        Assert.assertEquals((Object)d2, heap.popMin());
        Assert.assertEquals((int)0, (int)heap.size());
    }

    @Test
    public void testTwo() {
        MinMaxHeap<DoubleS> heap = new MinMaxHeap<DoubleS>(2);
        Assert.assertEquals((int)0, (int)heap.size());
        DoubleS d1 = new DoubleS(1.0);
        heap.add(d1);
        Assert.assertEquals((int)1, (int)heap.size());
        Assert.assertEquals((Object)d1, heap.peekMax());
        Assert.assertEquals((Object)d1, heap.peekMin());
        DoubleS d2 = new DoubleS(2.0);
        heap.add(d2);
        Assert.assertEquals((int)2, (int)heap.size());
        Assert.assertEquals((Object)d2, heap.peekMax());
        Assert.assertEquals((Object)d1, heap.peekMin());
        DoubleS d0 = new DoubleS(0.0);
        heap.add(d0);
        Assert.assertEquals((int)2, (int)heap.size());
        Assert.assertEquals((Object)d2, heap.peekMax());
        Assert.assertEquals((Object)d1, heap.peekMin());
        DoubleS d4 = new DoubleS(4.0);
        heap.add(d4);
        Assert.assertEquals((int)2, (int)heap.size());
        Assert.assertEquals((Object)d4, heap.peekMax());
        Assert.assertEquals((Object)d2, heap.peekMin());
        DoubleS d3 = new DoubleS(3.0);
        heap.add(d3);
        Assert.assertEquals((int)2, (int)heap.size());
        Assert.assertEquals((Object)d4, heap.peekMax());
        Assert.assertEquals((Object)d3, heap.peekMin());
    }

    @Test
    public void testThree() {
        MinMaxHeap<DoubleS> heap = new MinMaxHeap<DoubleS>(3);
        Assert.assertEquals((int)0, (int)heap.size());
        DoubleS d1 = new DoubleS(1.0);
        heap.add(d1);
        Assert.assertEquals((int)1, (int)heap.size());
        Assert.assertEquals((Object)d1, heap.peekMax());
        Assert.assertEquals((Object)d1, heap.peekMin());
        DoubleS d2 = new DoubleS(2.0);
        heap.add(d2);
        Assert.assertEquals((int)2, (int)heap.size());
        Assert.assertEquals((Object)d2, heap.peekMax());
        Assert.assertEquals((Object)d1, heap.peekMin());
        DoubleS d3 = new DoubleS(3.0);
        heap.add(d3);
        Assert.assertEquals((int)3, (int)heap.size());
        Assert.assertEquals((Object)d3, heap.peekMax());
        Assert.assertEquals((Object)d1, heap.peekMin());
        DoubleS d0 = new DoubleS(0.0);
        heap.add(d0);
        Assert.assertEquals((int)3, (int)heap.size());
        Assert.assertEquals((Object)d3, heap.peekMax());
        Assert.assertEquals((Object)d1, heap.peekMin());
        DoubleS d2_5 = new DoubleS(2.5);
        heap.add(d2_5);
        Assert.assertEquals((int)3, (int)heap.size());
        Assert.assertEquals((Object)d3, heap.peekMax());
        Assert.assertEquals((Object)d2, heap.peekMin());
        DoubleS d5 = new DoubleS(5.0);
        heap.add(d5);
        Assert.assertEquals((int)3, (int)heap.size());
        Assert.assertEquals((Object)d5, heap.peekMax());
        Assert.assertEquals((Object)d2_5, heap.peekMin());
        DoubleS d4 = new DoubleS(4.0);
        heap.add(d4);
        Assert.assertEquals((int)3, (int)heap.size());
        Assert.assertEquals((Object)d5, heap.peekMax());
        Assert.assertEquals((Object)d3, heap.peekMin());
    }

    @Test
    public void testAdd() {
        for (int numTests = 0; numTests < 10; ++numTests) {
            for (int size = 1; size < 150; ++size) {
                int i;
                MinMaxHeap<Scored> heap = new MinMaxHeap<Scored>(size);
                Assert.assertEquals((int)0, (int)heap.size());
                Scored[] scoreds = this.sample(RANDOM.nextInt(1000) + size);
                for (i = 0; i < scoreds.length; ++i) {
                    heap.add(scoreds[i]);
                }
                Assert.assertEquals((int)size, (int)heap.size());
                Arrays.sort(scoreds, ScoredObject.reverseComparator());
                i = 0;
                while (true) {
                    Object next;
                    if ((next = heap.popMax()) == null) break;
                    Assert.assertEquals((Object)scoreds[i], next);
                    ++i;
                }
                Assert.assertEquals((int)size, (int)i);
                Assert.assertEquals((int)0, (int)heap.size());
            }
        }
    }

    public Scored[] sample(int size) {
        Scored[] result = new Scored[size];
        for (int i = 0; i < size; ++i) {
            result[i] = new DoubleS(RANDOM.nextDouble());
        }
        return result;
    }

    static class DoubleS
    implements Scored {
        final double mX;

        public DoubleS(double x) {
            this.mX = x;
        }

        @Override
        public double score() {
            return this.mX;
        }

        public String toString() {
            return Double.toString(this.mX);
        }
    }
}

