/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.util;

import com.aliasi.util.ObjectToDoubleMap;
import com.aliasi.util.ScoredObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class ObjectToDoubleMapTest {
    @Test
    public void testZeroSet() {
        ObjectToDoubleMap<String> map = new ObjectToDoubleMap<String>();
        Assert.assertEquals((int)map.size(), (int)0);
        map.setAndKeepZeros("a", 0.0);
        Assert.assertEquals((int)map.size(), (int)1);
        map.set("a", 0.0);
        Assert.assertEquals((int)map.size(), (int)0);
    }

    @Test
    public void testIncrement() {
        ObjectToDoubleMap<String> map = new ObjectToDoubleMap<String>();
        Assert.assertEquals((double)0.0, (double)map.getValue("a"), (double)1.0E-4);
        map.increment("a", 1.0);
        Assert.assertEquals((double)1.0, (double)map.getValue("a"), (double)0.001);
        map.increment("a", 2.5);
        Assert.assertEquals((double)3.5, (double)map.getValue("a"), (double)0.001);
        map.increment("a", 5.0);
        Assert.assertEquals((double)8.5, (double)map.getValue("a"), (double)0.001);
        Assert.assertTrue((boolean)map.containsKey("a"));
        map.increment("a", -7.0);
        Assert.assertEquals((double)1.5, (double)map.getValue("a"), (double)0.001);
        map.increment("b", 1.0);
        Assert.assertEquals((double)1.0, (double)map.getValue("b"), (double)0.001);
        map.increment("b", -1.0);
        Assert.assertEquals((double)0.0, (double)map.getValue("b"), (double)0.001);
        Assert.assertFalse((boolean)map.containsKey("b"));
    }

    @Test
    public void testSet() {
        ObjectToDoubleMap<String> map = new ObjectToDoubleMap<String>();
        map.set("a", 3.0);
        Assert.assertEquals((double)3.0, (double)map.getValue("a"), (double)0.001);
        Assert.assertTrue((boolean)map.containsKey("a"));
        map.set("a", 0.0);
        Assert.assertEquals((double)0.0, (double)map.getValue("a"), (double)0.001);
        Assert.assertFalse((boolean)map.containsKey("a"));
        map.set("a", 3.0);
        map.set("a", 4.0);
        Assert.assertEquals((double)4.0, (double)map.getValue("a"), (double)0.001);
        map.set("b", 17.0);
        Assert.assertEquals((double)17.0, (double)map.getValue("b"), (double)0.001);
    }

    @Test
    public void testKeysOrderedByCount() {
        ObjectToDoubleMap<String> map = new ObjectToDoubleMap<String>();
        List keysOrderedByCountZero = map.keysOrderedByValueList();
        Assert.assertEquals(new ArrayList(), keysOrderedByCountZero);
        map.set("e", 1.0);
        map.set("c", 3.0);
        map.set("d", 2.0);
        map.set("a", 5.0);
        List keysOrderedByCount = map.keysOrderedByValueList();
        Assert.assertEquals(Arrays.asList("a", "c", "d", "e"), keysOrderedByCount);
    }

    @Test
    public void testScoredObjects() {
        ObjectToDoubleMap<String> map = new ObjectToDoubleMap<String>();
        List sos1 = map.scoredObjectsOrderedByValueList();
        Assert.assertEquals(new ArrayList(), sos1);
        map.set("e", 1.0);
        map.set("c", 3.0);
        map.set("d", 2.0);
        map.set("a", 5.0);
        ScoredObject[] sos2s = new ScoredObject[]{new ScoredObject<String>("a", 5.0), new ScoredObject<String>("c", 3.0), new ScoredObject<String>("d", 2.0), new ScoredObject<String>("e", 1.0)};
        List<ScoredObject> sos2 = Arrays.asList(sos2s);
        List keysOrderedByCount = map.scoredObjectsOrderedByValueList();
        Assert.assertEquals((int)sos2.size(), (int)keysOrderedByCount.size());
        for (int i = 0; i < sos2.size(); ++i) {
            Assert.assertEquals((double)sos2.get(i).score(), (double)keysOrderedByCount.get(i).score(), (double)1.0E-4);
            Assert.assertEquals(sos2.get(i).getObject(), keysOrderedByCount.get(i).getObject());
        }
    }

    @Test
    public void testCountComparator() {
        ObjectToDoubleMap<Object> map = new ObjectToDoubleMap<Object>();
        Object o1 = new Object();
        Object o2 = new Object();
        map.set(o1, 2.0);
        map.set(o2, 2.0);
        Assert.assertEquals((int)0, (int)map.valueComparator().compare(o1, o2));
        map.set(o1, 3.0);
        Assert.assertEquals((int)-1, (int)map.valueComparator().compare(o1, o2));
        map.set(o1, 1.0);
        Assert.assertEquals((int)1, (int)map.valueComparator().compare(o1, o2));
        String s1 = "a";
        String s2 = "b";
        map.set(s1, 2.0);
        map.set(s2, 2.0);
        Assert.assertEquals((int)-1, (int)map.valueComparator().compare(s1, s2));
        map.set(s1, 3.0);
        Assert.assertEquals((int)-1, (int)map.valueComparator().compare(s1, s2));
        map.set(s1, 1.0);
        Assert.assertEquals((int)1, (int)map.valueComparator().compare(s1, s2));
        map.set(o1, 1.0);
        map.set(s1, 1.0);
        Assert.assertEquals((int)0, (int)map.valueComparator().compare(o1, s1));
    }
}

