/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.util;

import com.aliasi.util.Sgml;
import junit.framework.Assert;
import org.junit.Test;

public class SgmlTest {
    @Test
    public void test() {
        Assert.assertNull((Object)Sgml.entityToCharacter("foobar"));
        Assert.assertEquals((Object)Character.valueOf('\u200c'), (Object)Sgml.entityToCharacter("zwnj"));
        this.assertSub("", "");
        this.assertSub("foobar", "foobar");
        this.assertSub("&Agr;", "\u0391");
        this.assertSub("foo&Agr;", "foo\u0391");
        this.assertSub("&Agr;foo", "\u0391foo");
        this.assertSub("foo&Agr;bar", "foo\u0391bar");
        this.assertSub("&Foobar;", "?");
        this.assertSub("&aleph;", "\u2135");
        this.assertSub("&aleph;&acute;", "\u2135\u00b4");
        this.assertSub("&aleph;foo&acute;", "\u2135foo\u00b4");
        this.assertSub("foo&aleph;bar&acute;baz", "foo\u2135bar\u00b4baz");
        this.assertSub("&Foobar;", "baz", "baz");
    }

    void assertSub(String in, String expected) {
        this.assertSub(in, expected, null);
    }

    void assertSub(String in, String expected, String unk) {
        Assert.assertEquals((String)expected, (String)(unk != null ? Sgml.replaceEntities(in, unk) : Sgml.replaceEntities(in)));
    }
}

