/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.util;

import com.aliasi.test.unit.Asserts;
import com.aliasi.util.SmallSet;
import java.util.HashSet;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class SmallSetTest {
    private SmallSet setEmpty;
    private SmallSet setEmptyC;
    private SmallSet set1;
    private SmallSet set1C;
    private SmallSet set2;
    private SmallSet set3;
    private SmallSet set12;
    private SmallSet set123;

    public void testEmtpySetMulti() {
        SmallSet stringSet = SmallSet.create();
        SmallSet intSet = SmallSet.create();
        Assert.assertEquals(stringSet, intSet);
        Assert.assertEquals(new HashSet(), new HashSet());
        SmallSet<String> s2 = stringSet.union(SmallSet.create("abc"));
        HashSet<String> expS2 = new HashSet<String>();
        expS2.add("abc");
        Assert.assertEquals(expS2, s2);
        SmallSet<Integer> s3 = intSet.union(SmallSet.create(5));
        HashSet<Integer> expS3 = new HashSet<Integer>();
        expS3.add(5);
        Assert.assertEquals(expS3, s3);
    }

    @Before
    public void setUp() {
        this.setEmpty = SmallSet.create();
        this.setEmptyC = SmallSet.create();
        this.set1 = SmallSet.create(1);
        this.set1C = SmallSet.create(1);
        this.set2 = SmallSet.create(2);
        this.set3 = SmallSet.create(3);
        this.set12 = SmallSet.create(Integer.valueOf(1), 2);
        this.set123 = SmallSet.create(new Integer[]{1, 2, 3});
        SmallSet.create(new Integer[]{1, 2, 3, 4});
        SmallSet.create(new Integer[]{1, 2, 3, 4, 5});
    }

    @Test
    public void testEmptySet() {
        Assert.assertEquals((int)this.setEmpty.size(), (int)0);
        Asserts.assertFullEquals(this.setEmpty, this.setEmptyC);
        Assert.assertFalse((boolean)this.setEmpty.contains(0));
        this.testUnion(this.setEmpty, this.setEmpty, this.setEmpty);
    }

    @Test
    public void testSingleton() {
        Assert.assertEquals((int)this.set1.size(), (int)1);
        Assert.assertFalse((boolean)this.set1.contains(0));
        Assert.assertTrue((boolean)this.set1.contains(1));
        Asserts.assertFullEquals(this.set1, this.set1C);
        this.testUnion(this.set1, this.setEmpty, this.set1);
        Assert.assertEquals((Object)this.set1, SmallSet.create(Integer.valueOf(1), 1));
    }

    @Test
    public void testPair() {
        Assert.assertEquals((int)this.set12.size(), (int)2);
        Assert.assertFalse((boolean)this.set12.contains(0));
        Assert.assertTrue((boolean)this.set12.contains(1));
        Assert.assertTrue((boolean)this.set12.contains(2));
        this.testUnion(this.set1, this.set2, this.set12);
        this.testUnion(this.set1, this.set12, this.set12);
        this.testUnion(this.setEmpty, this.set12, this.set12);
    }

    @Test
    public void testTriple() {
        Assert.assertEquals((int)this.set123.size(), (int)3);
        Assert.assertTrue((boolean)this.set123.contains(1));
        Assert.assertTrue((boolean)this.set123.contains(2));
        Assert.assertTrue((boolean)this.set123.contains(3));
        Assert.assertFalse((boolean)this.set123.contains(0));
        this.testUnion(this.set12, this.set3, this.set123);
        this.testUnion(this.set123, this.setEmpty, this.set123);
        this.testUnion(this.set123, this.set1, this.set123);
        this.testUnion(this.set123, this.set12, this.set123);
        this.testUnion(this.set123, this.set123, this.set123);
    }

    public void testUnion(SmallSet set1, SmallSet set2, SmallSet result) {
        Asserts.assertFullEquals(set1.union(set2), result);
        Asserts.assertFullEquals(set2.union(set1), result);
    }
}

