/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.util;

import com.aliasi.util.Streams;
import com.aliasi.util.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.InputSource;

public class StreamsTest {
    static String FILE_URL_PREFIX = "file:///";
    static final String TEMP_DIRECTORY_SYS_PROPERTY = "java.io.tmpdir";
    static final File TEMP_DIRECTORY = new File(System.getProperty("java.io.tmpdir"));

    static String fileToURLName(File file) throws IOException {
        return FILE_URL_PREFIX + file.getCanonicalPath();
    }

    static File createTempFile(String fileName) {
        File tempFile = new File(TEMP_DIRECTORY, fileName);
        tempFile.deleteOnExit();
        return tempFile;
    }

    static void writeStringToFile(String s, File file) throws IOException {
        StreamsTest.writeCharsToFile(s.toCharArray(), file);
    }

    static void writeStringToFile(String s, File file, String encoding) throws IOException {
        StreamsTest.writeCharsToFile(s.toCharArray(), file, encoding);
    }

    static void writeCharsToFile(char[] chars, File file) throws IOException {
        StreamsTest.writeCharsToFile(chars, file, Strings.UTF8);
    }

    static void writeCharsToFile(char[] chars, File file, String encoding) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, encoding);
        writer.write(chars);
        Streams.closeQuietly(writer);
    }

    @Test
    public void testGetDefaultJavaCharset() {
        junit.framework.Assert.assertNotNull((Object)Streams.getDefaultJavaCharset());
    }

    @Test
    public void testCopyReader() throws IOException {
        this.assertCopyReader(new char[0]);
        this.assertCopyReader(new char[]{'a', 'b', 'c'});
        char[] chars = new char[100000];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = 97;
        }
        this.assertCopyReader(chars);
    }

    @Test
    public void testCopyStream() throws IOException {
        this.assertCopyStream(new byte[0]);
        this.assertCopyStream(new byte[]{17, 12, 13});
        byte[] bytes = new byte[100000];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = 12;
        }
        this.assertCopyStream(bytes);
    }

    @Test
    public void testCloseInputStream() {
        Streams.closeQuietly(null);
        DummyInputStream in = new DummyInputStream();
        Streams.closeQuietly(in);
        junit.framework.Assert.assertTrue((boolean)in.isClosed());
    }

    @Test
    public void testCloseOutputStream() {
        Streams.closeQuietly(null);
        DummyOutputStream out = new DummyOutputStream();
        junit.framework.Assert.assertFalse((boolean)out.isClosed());
        Streams.closeQuietly(out);
        junit.framework.Assert.assertTrue((boolean)out.isClosed());
    }

    @Test
    public void testCloseReader() {
        Streams.closeQuietly(null);
        DummyReader reader = new DummyReader();
        junit.framework.Assert.assertFalse((boolean)reader.isClosed());
        Streams.closeQuietly(reader);
        junit.framework.Assert.assertTrue((boolean)reader.isClosed());
    }

    @Test
    public void testCloseWriter() {
        Streams.closeQuietly(null);
        DummyWriter writer = new DummyWriter();
        junit.framework.Assert.assertFalse((boolean)writer.isClosed());
        Streams.closeQuietly(writer);
        junit.framework.Assert.assertTrue((boolean)writer.isClosed());
    }

    @Test
    public void testToCharArray() throws IOException {
        String t1 = "SIL-1";
        StringReader reader = new StringReader(t1);
        InputSource in = new InputSource(reader);
        junit.framework.Assert.assertEquals((String)t1, (String)new String(Streams.toCharArray(in)));
        byte[] bytes = t1.getBytes();
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes);
        in = new InputSource(bytesIn);
        junit.framework.Assert.assertEquals((String)t1, (String)new String(Streams.toCharArray(in)));
        bytes = t1.getBytes("UTF-16");
        bytesIn = new ByteArrayInputStream(bytes);
        in = new InputSource(bytesIn);
        in.setEncoding("UTF-16");
        junit.framework.Assert.assertEquals((String)t1, (String)new String(Streams.toCharArray(in)));
        File tempFile = StreamsTest.createTempFile("LingPipe_StreamsTest");
        StreamsTest.writeStringToFile(t1, tempFile);
        String urlName = StreamsTest.fileToURLName(tempFile);
        in = new InputSource(urlName);
        junit.framework.Assert.assertEquals((String)t1, (String)new String(Streams.toCharArray(in)));
        StreamsTest.writeStringToFile(t1, tempFile, "UTF-16");
        in = new InputSource(urlName);
        in.setEncoding("UTF-16");
        junit.framework.Assert.assertEquals((String)t1, (String)new String(Streams.toCharArray(in)));
    }

    private void assertCopyReader(char[] chars) throws IOException {
        CharArrayReader reader = new CharArrayReader(chars);
        CharArrayWriter writer = new CharArrayWriter();
        Streams.copy(reader, writer);
        Assert.assertArrayEquals((char[])chars, (char[])writer.toCharArray());
    }

    private void assertCopyStream(byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Streams.copy(in, out);
        Assert.assertArrayEquals((byte[])bytes, (byte[])out.toByteArray());
    }

    private static class DummyWriter
    extends Writer {
        private boolean mIsClosed = false;

        private DummyWriter() {
        }

        @Override
        public void write(char[] chars, int offset, int length) {
        }

        @Override
        public void close() {
            this.mIsClosed = true;
        }

        @Override
        public void flush() {
        }

        public boolean isClosed() {
            return this.mIsClosed;
        }
    }

    private static class DummyReader
    extends Reader {
        private boolean mIsClosed = false;

        private DummyReader() {
        }

        @Override
        public int read(char[] chars, int offset, int length) {
            return -1;
        }

        @Override
        public void close() {
            this.mIsClosed = true;
        }

        public boolean isClosed() {
            return this.mIsClosed;
        }
    }

    private static class DummyInputStream
    extends InputStream {
        private boolean mIsClosed = false;

        private DummyInputStream() {
        }

        @Override
        public int read() throws IOException {
            return -1;
        }

        @Override
        public void close() {
            this.mIsClosed = true;
        }

        public boolean isClosed() {
            return this.mIsClosed;
        }
    }

    private static class DummyOutputStream
    extends OutputStream {
        private boolean mIsClosed = false;

        private DummyOutputStream() {
        }

        @Override
        public void write(int c) throws IOException {
        }

        @Override
        public void close() {
            this.mIsClosed = true;
        }

        public boolean isClosed() {
            return this.mIsClosed;
        }
    }
}

