/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.util;

import com.aliasi.test.unit.Asserts;
import com.aliasi.util.Tuple;
import junit.framework.Assert;
import org.junit.Test;

public class TupleTest {
    @Test
    public void testEmpty() {
        Tuple<Object> zeroton = Tuple.create(new Object[0]);
        Tuple<Object> zeroton2 = Tuple.create(new Object[0]);
        Tuple<Object> singletonA = Tuple.create(new Object[]{"A"});
        Tuple<Object> singletonA2 = Tuple.create(new Object[]{"A"});
        Tuple<Object> singletonB = Tuple.create(new Object[]{"B"});
        Tuple<Object> pairAB = Tuple.create(new Object[]{"A", "B"});
        Tuple<Object> pairAB2 = Tuple.create(new Object[]{"A", "B"});
        Tuple<Object> pairAC = Tuple.create(new Object[]{"A", "A"});
        Tuple<Object> tripleABC = Tuple.create(new Object[]{"A", "B", "C"});
        Tuple<Object> tripleABC2 = Tuple.create(new Object[]{"A", "B", "C"});
        Tuple<Object> tripleABD = Tuple.create(new Object[]{"A", "B", "D"});
        Assert.assertNotNull(zeroton);
        Assert.assertNotNull(singletonA);
        Assert.assertNotNull(pairAB);
        Assert.assertNotNull(tripleABC);
        Asserts.assertFullEquals(zeroton, zeroton2);
        Asserts.assertFullEquals(singletonA, singletonA2);
        Asserts.assertFullEquals(singletonA, singletonA2);
        Asserts.assertFullEquals(pairAB, pairAB2);
        Asserts.assertFullEquals(tripleABC, tripleABC2);
        Assert.assertEquals((int)0, (int)zeroton.size());
        Assert.assertEquals((int)1, (int)singletonA.size());
        Assert.assertEquals((int)2, (int)pairAB.size());
        Assert.assertEquals((int)3, (int)tripleABC.size());
        Assert.assertEquals((Object)"A", (Object)singletonA.get(0));
        Assert.assertEquals((Object)"A", (Object)pairAB.get(0));
        Assert.assertEquals((Object)"B", (Object)pairAB.get(1));
        Assert.assertEquals((Object)"C", (Object)tripleABC.get(2));
        Asserts.assertNotEquals(null, zeroton);
        Asserts.assertNotEquals(null, singletonA);
        Asserts.assertNotEquals(null, pairAB);
        Asserts.assertNotEquals(null, tripleABC);
        Asserts.assertNotEquals(zeroton, singletonA);
        Asserts.assertNotEquals(zeroton, pairAB);
        Asserts.assertNotEquals(zeroton, tripleABC);
        Asserts.assertNotEquals(singletonA, pairAB);
        Asserts.assertNotEquals(singletonA, tripleABC);
        Asserts.assertNotEquals(pairAB, tripleABC);
        Asserts.assertNotEquals(singletonA, singletonB);
        Asserts.assertNotEquals(pairAB, pairAC);
        Asserts.assertNotEquals(tripleABC, tripleABD);
    }

    @Test
    public void testArrayBounds() {
        Tuple<Object> zeroton = Tuple.create(new Object[0]);
        boolean threw = false;
        try {
            zeroton.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            threw = true;
        }
        Assert.assertTrue((boolean)threw);
        threw = false;
        try {
            zeroton.get(-1);
        }
        catch (IndexOutOfBoundsException e) {
            threw = true;
        }
        Assert.assertTrue((boolean)threw);
        Tuple<Object> singleton = Tuple.create(new Object[]{"A"});
        threw = false;
        try {
            singleton.get(-1);
        }
        catch (IndexOutOfBoundsException e) {
            threw = true;
        }
        Assert.assertTrue((boolean)threw);
        threw = false;
        try {
            singleton.get(15);
        }
        catch (IndexOutOfBoundsException e) {
            threw = true;
        }
        Assert.assertTrue((boolean)threw);
        Tuple<Object> pair = Tuple.create(new Object[]{"A", "B"});
        threw = false;
        try {
            pair.get(-1);
        }
        catch (IndexOutOfBoundsException e) {
            threw = true;
        }
        Assert.assertTrue((boolean)threw);
        threw = false;
        try {
            pair.get(3);
        }
        catch (IndexOutOfBoundsException e) {
            threw = true;
        }
        Assert.assertTrue((boolean)threw);
        Tuple<Object> triple = Tuple.create(new Object[]{"A", "B", "C"});
        threw = false;
        try {
            triple.get(-1);
        }
        catch (IndexOutOfBoundsException e) {
            threw = true;
        }
        Assert.assertTrue((boolean)threw);
        threw = false;
        try {
            triple.get(3);
        }
        catch (IndexOutOfBoundsException e) {
            threw = true;
        }
        Assert.assertTrue((boolean)threw);
    }
}

