/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.xml;

import com.aliasi.test.unit.xml.MultiHandler;
import com.aliasi.test.unit.xml.TopHandler;
import java.io.CharArrayReader;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DelegatingHandlerTest {
    @Test
    public void testOne() throws IOException, SAXException {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        TopHandler testHandler = new TopHandler();
        xmlReader.setContentHandler(testHandler);
        String chars = "<DOC><A><LIST><ELT>a</ELT><ELT>b</ELT><ELT>c</ELT></LIST></A><B><LIST><ELT>1</ELT><ELT>2</ELT></LIST></B></DOC>";
        CharArrayReader charReader = new CharArrayReader(chars.toCharArray());
        InputSource inSource = new InputSource(charReader);
        xmlReader.parse(inSource);
        Object[] expectedAValue = new String[]{"a", "b", "c"};
        Object[] expectedBValue = new String[]{"1", "2"};
        Assert.assertArrayEquals((Object[])expectedAValue, (Object[])testHandler.aValue());
        Assert.assertArrayEquals((Object[])expectedBValue, (Object[])testHandler.bValue());
    }

    @Test
    public void testMulti() throws IOException, SAXException {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        MultiHandler handler = new MultiHandler();
        xmlReader.setContentHandler(handler);
        String chars = "<A><B>foo</B><C><B>bar</B></C></A>";
        CharArrayReader reader = new CharArrayReader(chars.toCharArray());
        InputSource in = new InputSource(reader);
        xmlReader.parse(in);
        junit.framework.Assert.assertEquals((String)"foo", (String)handler.b());
        junit.framework.Assert.assertEquals((String)"bar", (String)handler.c());
    }
}

