/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.tokenizer;

import com.aliasi.tokenizer.TokenCategorizer;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Compilable;
import com.aliasi.util.Strings;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class IndoEuropeanTokenCategorizer
implements Compilable,
TokenCategorizer {
    private static final String NULL_CLASS = "NULL-TOK";
    private static final String ONE_DIGIT_CLASS = "1-DIG";
    private static final String TWO_DIGIT_CLASS = "2-DIG";
    private static final String THREE_DIGIT_CLASS = "3-DIG";
    private static final String FOUR_DIGIT_CLASS = "4-DIG";
    private static final String FIVE_PLUS_DIGITS_CLASS = "5+-DIG";
    private static final String DIGITS_LETTERS_CLASS = "DIG-LET";
    private static final String MISC_DIGITS_CLASS = "DIG-MSC";
    private static final String DIGITS_DASH_CLASS = "DIG--";
    private static final String DIGITS_SLASH_CLASS = "DIG-/";
    private static final String DIGITS_COMMA_CLASS = "DIG-,";
    private static final String DIGITS_PERIOD_CLASS = "DIG-.";
    private static final String UPPERCASE_CLASS = "LET-UP";
    private static final String LOWERCASE_CLASS = "LET-LOW";
    private static final String CAPITALIZED_CLASS = "LET-CAP";
    private static final String MIXEDCASE_CLASS = "LET-MIX";
    private static final String ONE_UPPERCASE_CLASS = "1-LET-UP";
    private static final String ONE_LOWERCASE_CLASS = "1-LET-LOW";
    private static final String PUNCTUATION_CLASS = "PUNC-";
    private static final String OTHER_CLASS = "OTHER";
    private static final String[] CATEGORY_ARRAY = new String[]{"NULL-TOK", "1-DIG", "2-DIG", "3-DIG", "4-DIG", "5+-DIG", "DIG-LET", "DIG-MSC", "DIG--", "DIG-/", "DIG-,", "DIG-.", "LET-UP", "LET-LOW", "LET-CAP", "LET-MIX", "OTHER", "1-LET-UP", "1-LET-LOW", "PUNC-"};
    public static final IndoEuropeanTokenCategorizer CATEGORIZER = new IndoEuropeanTokenCategorizer();

    IndoEuropeanTokenCategorizer() {
    }

    @Override
    public String categorize(String token) {
        char[] chars = token.toCharArray();
        if (chars.length == 0) {
            return NULL_CLASS;
        }
        if (Strings.allDigits(chars, 0, chars.length)) {
            if (chars.length == 1) {
                return ONE_DIGIT_CLASS;
            }
            if (chars.length == 2) {
                return TWO_DIGIT_CLASS;
            }
            if (chars.length == 3) {
                return THREE_DIGIT_CLASS;
            }
            if (chars.length == 4) {
                return FOUR_DIGIT_CLASS;
            }
            return FIVE_PLUS_DIGITS_CLASS;
        }
        if (Strings.containsDigits(chars)) {
            if (Strings.containsLetter(chars)) {
                return DIGITS_LETTERS_CLASS;
            }
            if (token.indexOf(45) >= 0) {
                return DIGITS_DASH_CLASS;
            }
            if (token.indexOf(47) >= 0) {
                return DIGITS_SLASH_CLASS;
            }
            if (token.indexOf(44) >= 0) {
                return DIGITS_COMMA_CLASS;
            }
            if (token.indexOf(46) >= 0) {
                return DIGITS_PERIOD_CLASS;
            }
            return MISC_DIGITS_CLASS;
        }
        if (Strings.allPunctuation(chars)) {
            return PUNCTUATION_CLASS;
        }
        if (Character.isUpperCase(chars[0]) && chars.length == 1) {
            return ONE_UPPERCASE_CLASS;
        }
        if (Character.isLowerCase(chars[0]) && chars.length == 1) {
            return ONE_LOWERCASE_CLASS;
        }
        if (Strings.allUpperCase(chars)) {
            return UPPERCASE_CLASS;
        }
        if (Strings.allLowerCase(chars)) {
            return LOWERCASE_CLASS;
        }
        if (Strings.capitalized(chars)) {
            return CAPITALIZED_CLASS;
        }
        if (Strings.allLetters(chars)) {
            return MIXEDCASE_CLASS;
        }
        return OTHER_CLASS;
    }

    @Override
    public String[] categories() {
        return (String[])CATEGORY_ARRAY.clone();
    }

    @Override
    public void compileTo(ObjectOutput objOut) throws IOException {
        objOut.writeObject(new Externalizer());
    }

    private static class Externalizer
    extends AbstractExternalizable {
        private static final long serialVersionUID = -7153532326881222261L;

        @Override
        public void writeExternal(ObjectOutput objOut) {
        }

        @Override
        public Object read(ObjectInput objIn) {
            return CATEGORIZER;
        }
    }
}

