/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.tokenizer;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.ChunkFactory;
import com.aliasi.chunk.Chunker;
import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.ChunkingImpl;
import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Strings;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public class TokenChunker
implements Chunker,
Serializable {
    static final long serialVersionUID = -6559339721653291504L;
    private final TokenizerFactory mTokenizerFactory;

    public TokenChunker(TokenizerFactory tokenizerFactory) {
        this.mTokenizerFactory = tokenizerFactory;
    }

    public TokenizerFactory tokenizerFactory() {
        return this.mTokenizerFactory;
    }

    @Override
    public Chunking chunk(CharSequence cSeq) {
        char[] cs = Strings.toCharArray(cSeq);
        return this.chunk(cs, 0, cs.length);
    }

    @Override
    public Chunking chunk(char[] cs, int start, int end) {
        String token;
        Tokenizer tokenizer = this.mTokenizerFactory.tokenizer(cs, start, end - start);
        ChunkingImpl chunking = new ChunkingImpl(cs, start, end);
        while ((token = tokenizer.nextToken()) != null) {
            int chunkStart = tokenizer.lastTokenStartPosition();
            int chunkEnd = tokenizer.lastTokenEndPosition();
            Chunk chunk = ChunkFactory.createChunk(chunkStart, chunkEnd, token);
            chunking.add(chunk);
        }
        return chunking;
    }

    static class Serializer
    extends AbstractExternalizable {
        static final long serialVersionUID = 5541846439684999440L;
        private final TokenChunker mChunker;

        public Serializer(TokenChunker chunker) {
            this.mChunker = chunker;
        }

        public Serializer() {
            this(null);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.mChunker.tokenizerFactory());
        }

        @Override
        public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
            TokenizerFactory tokenizerFactory = (TokenizerFactory)in.readObject();
            return new TokenChunker(tokenizerFactory);
        }
    }
}

