/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import java.io.IOException;

public class Exceptions {
    private Exceptions() {
    }

    public static IOException toIO(String msg, Throwable t) {
        IOException e = new IOException(Exceptions.message(msg, t));
        Exceptions.copyStack(t, e);
        return e;
    }

    public static IllegalArgumentException toIllegalArgument(String msg, Throwable t) {
        IllegalArgumentException e = new IllegalArgumentException(Exceptions.message(msg, t));
        Exceptions.copyStack(t, e);
        return e;
    }

    public static void finiteNonNegative(String name, double value) {
        if (Double.isNaN(value) || Double.isInfinite(value) || value < 0.0) {
            String msg = name + " must be finite and non-negative. Found " + name + "=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    public static void finite(String name, double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            String msg = name + " must be finite. Found " + name + "=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    private static String message(String msg, Throwable t) {
        return msg + " Rethrown. Original throwable class=" + t.getClass().toString() + " Original message=" + t.getMessage();
    }

    private static void copyStack(Throwable from, Throwable to) {
        to.setStackTrace(from.getStackTrace());
    }
}

