/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.util;

import java.util.Random;

public class Sort {
    static int MIN_QSORT_SIZE = 7;
    public static final CompareInt NATURAL_INT_COMPARE = new CompareInt(){

        @Override
        public boolean lessThan(int a, int b) {
            return a < b;
        }
    };

    private Sort() {
    }

    public static void isort(int[] x, CompareInt compare) {
        for (int i = 0; i < x.length; ++i) {
            int t = x[i];
            for (int j = i; j > 0 && compare.lessThan(t, x[j - 1]); --j) {
                x[j] = x[j - 1];
            }
            x[j] = t;
        }
    }

    public static void qsort(int[] x, CompareInt compare) {
        Random random = new Random();
        Sort.qsortPartial(x, 0, x.length - 1, compare, random);
        Sort.isort(x, compare);
    }

    static void qsortPartial(int[] x, int lower, int upper, CompareInt compare, Random random) {
        if (upper - lower < MIN_QSORT_SIZE) {
            return;
        }
        Sort.swap(x, lower, lower + random.nextInt(upper - lower + 1));
        int t = x[lower];
        int i = lower;
        int j = upper + 1;
        while (true) {
            if (++i <= upper && compare.lessThan(x[i], t)) {
                continue;
            }
            while (compare.lessThan(t, x[--j])) {
            }
            if (i > j) break;
            Sort.swap(x, i, j);
        }
    }

    static void qsort2(int[] x, int lower, int upper, CompareInt compare) {
        if (lower > upper) {
            return;
        }
        int mid = lower;
        for (int i = lower + 1; i <= upper; ++i) {
            if (!compare.lessThan(x[i], x[lower])) continue;
            Sort.swap(x, ++mid, i);
        }
        Sort.swap(x, lower, mid);
        Sort.qsort2(x, lower, mid - 1, compare);
        Sort.qsort2(x, mid + 1, upper, compare);
    }

    public static void swap(int[] xs, int i, int j) {
        int temp = xs[i];
        xs[i] = xs[j];
        xs[j] = temp;
    }

    public static interface CompareInt {
        public boolean lessThan(int var1, int var2);
    }
}

