/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.costosys.cli;

import de.julielab.xml.JulieXMLTools;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractDeleteCitations {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractDeleteCitations.class);

    public static void main(String[] args) {
        ExtractDeleteCitations.extractDeletedPMIDs();
    }

    private static void extractDeletedPMIDs() {
        LOG.info("Starting extraction...");
        File baseDir = new File("/data/data_corpora/medline/updates");
        if (!baseDir.isDirectory()) {
            LOG.error(String.format("Path %s does not point to a directory.", baseDir.getAbsolutePath()));
            System.exit(1);
        }
        String[] fileNames = baseDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.endsWith(".gz");
            }
        });
        String forEachXpath = "/MedlineCitationSet/DeleteCitation/PMID";
        ArrayList fields = new ArrayList();
        HashMap<String, String> field = new HashMap<String, String>();
        field.put("name", "pmid");
        field.put("xpath", "/MedlineCitationSet/DeleteCitation/PMID");
        fields.add(field);
        int bufferSize = 1000;
        for (String fileName : fileNames) {
            Iterator it = JulieXMLTools.constructRowIterator((String)(baseDir.getAbsolutePath() + "/" + fileName), (int)bufferSize, (String)forEachXpath, fields, (boolean)false);
            while (it.hasNext()) {
                Map row = (Map)it.next();
                String pmid = (String)row.get("pmid");
                System.out.println(pmid);
            }
        }
    }
}

