/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.annotationadder;

import de.julielab.jcore.ae.annotationadder.AnnotationAdderAnnotator;
import de.julielab.jcore.ae.annotationadder.AnnotationAdderConfiguration;
import de.julielab.jcore.ae.annotationadder.annotationrepresentations.ExternalAnnotation;
import de.julielab.jcore.types.Token;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class AnnotationAdderHelper {
    private List<Token> tokenList;

    public void setAnnotationOffsets(Annotation annotation, ExternalAnnotation a, AnnotationAdderConfiguration configuration) throws CASException {
        if (configuration.getOffsetMode() == AnnotationAdderAnnotator.OffsetMode.CHARACTER) {
            annotation.setBegin(a.getStart());
            annotation.setEnd(a.getEnd());
        } else if (configuration.getOffsetMode() == AnnotationAdderAnnotator.OffsetMode.TOKEN) {
            JCas jCas = annotation.getCAS().getJCas();
            if (!JCasUtil.exists((JCas)jCas, Token.class)) {
                throw new IllegalArgumentException("The external annotations should be added according to token offset. However, no annotations of type " + Token.class.getCanonicalName() + " are present in the CAS.");
            }
            if (this.tokenList == null) {
                this.createTokenList(jCas);
            }
            int startTokenNum = a.getStart();
            int endTokenNum = a.getEnd();
            if (startTokenNum < 1 || startTokenNum > this.tokenList.size()) {
                throw new IllegalArgumentException("The current annotation to add to the CAS starts at token " + startTokenNum + " which does not fit to the range of tokens in the document which is 1 - " + this.tokenList.size());
            }
            if (endTokenNum < 1 || endTokenNum > this.tokenList.size()) {
                throw new IllegalArgumentException("The current annotation to add to the CAS ends at token " + endTokenNum + " which does not fit to the range of tokens in the document which is 1 - " + this.tokenList.size());
            }
            if (endTokenNum < startTokenNum) {
                throw new IllegalArgumentException("The current annotation to add has a lower end offset than start offset. Start: " + startTokenNum + ", end: " + endTokenNum);
            }
            int begin = this.tokenList.get(startTokenNum - 1).getBegin();
            int end = this.tokenList.get(endTokenNum - 1).getEnd();
            annotation.setBegin(begin);
            annotation.setEnd(end);
        }
    }

    private void createTokenList(JCas jCas) {
        this.tokenList = new ArrayList<Token>();
        FSIterator tokenIt = jCas.getAnnotationIndex(Token.type).iterator(false);
        while (tokenIt.hasNext()) {
            Token token = (Token)tokenIt.next();
            this.tokenList.add(token);
        }
    }
}

