/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.annotationadder;

import de.julielab.jcore.ae.annotationadder.AnnotationAdder;
import de.julielab.jcore.ae.annotationadder.AnnotationAdderConfiguration;
import de.julielab.jcore.ae.annotationadder.AnnotationAdderHelper;
import de.julielab.jcore.ae.annotationadder.annotationrepresentations.AnnotationData;
import de.julielab.jcore.ae.annotationadder.annotationrepresentations.AnnotationList;
import de.julielab.jcore.ae.annotationadder.annotationrepresentations.ExternalAnnotation;
import de.julielab.jcore.utility.JCoReAnnotationTools;
import java.lang.reflect.InvocationTargetException;
import org.apache.uima.cas.CASException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationListAdder
implements AnnotationAdder {
    private static final Logger log = LoggerFactory.getLogger(AnnotationListAdder.class);

    @Override
    public boolean addAnnotations(AnnotationData data, AnnotationAdderHelper helper, AnnotationAdderConfiguration configuration, JCas jCas) {
        AnnotationList annotationList;
        try {
            annotationList = (AnnotationList)data;
        }
        catch (ClassCastException e) {
            log.debug("AnnotationList adder rejected annotation data of class {}", (Object)data.getClass().getCanonicalName());
            return false;
        }
        for (ExternalAnnotation a : annotationList) {
            String uimaType;
            String string = uimaType = a.getUimaType() == null ? configuration.getDefaultUimaType() : a.getUimaType();
            if (uimaType == null) {
                throw new IllegalArgumentException("Missing annotation type: Neither the annotation of document " + a.getDocumentId() + " with offsets " + a.getStart() + "-" + a.getEnd() + " provides a type nor is the default type set.");
            }
            if (jCas.getTypeSystem().getType(uimaType) == null) {
                throw new IllegalArgumentException("The entity annotation type " + a.getUimaType() + " does not exist in the type system.");
            }
            try {
                Annotation annotation = JCoReAnnotationTools.getAnnotationByClassName((JCas)jCas, (String)uimaType);
                helper.setAnnotationOffsets(annotation, a, configuration);
                annotation.addToIndexes();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | CASException e) {
                e.printStackTrace();
            }
        }
        return true;
    }
}

