/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.annotationadder.annotationsources;

import de.julielab.java.utilities.FileUtilities;
import de.julielab.jcore.ae.annotationadder.annotationformat.AnnotationFormat;
import de.julielab.jcore.ae.annotationadder.annotationrepresentations.AnnotationList;
import de.julielab.jcore.ae.annotationadder.annotationrepresentations.ExternalAnnotation;
import de.julielab.jcore.ae.annotationadder.annotationsources.AnnotationSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.uima.resource.DataResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileEntityAnnotationSource
implements AnnotationSource<AnnotationList> {
    private static final Logger log = LoggerFactory.getLogger(FileEntityAnnotationSource.class);
    private AnnotationFormat<ExternalAnnotation> format;
    private Map<String, AnnotationList> entitiesByDocId;

    public FileEntityAnnotationSource(AnnotationFormat<ExternalAnnotation> format) {
        this.format = format;
    }

    public void loadAnnotations(File annotationfile) {
        try (BufferedReader br = FileUtilities.getReaderFromFile((File)annotationfile);){
            this.entitiesByDocId = br.lines().map(this.format::parse).collect(Collectors.groupingBy(ExternalAnnotation::getDocumentId, Collectors.toCollection(AnnotationList::new)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initialize(DataResource dataResource) {
        log.info("Loading entity annotations from {}", (Object)dataResource.getUri());
        this.loadAnnotations(new File(dataResource.getUri()));
    }

    @Override
    public AnnotationList getAnnotations(String id) {
        return this.entitiesByDocId.get(id);
    }
}

