/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.annotationadder;

import de.julielab.jcore.ae.annotationadder.AnnotationAdder;
import de.julielab.jcore.ae.annotationadder.AnnotationAdderConfiguration;
import de.julielab.jcore.ae.annotationadder.AnnotationAdderHelper;
import de.julielab.jcore.ae.annotationadder.DocumentClassAnnotationAdder;
import de.julielab.jcore.ae.annotationadder.TextAnnotationListAdder;
import de.julielab.jcore.ae.annotationadder.annotationrepresentations.AnnotationData;
import de.julielab.jcore.ae.annotationadder.annotationsources.AnnotationProvider;
import de.julielab.jcore.utility.JCoReTools;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ExternalResource;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ResourceMetaData(name="JCoRe Annotation Adder", description="This component helps to import annotations made on the exact CAS document text by an external process back into the CAS. To this end, the component is prepared to read several data formats. Currently, simple offset-based annotations are supported with configurable UIMA types. The component supports character and token based offsets.")
public class AnnotationAdderAnnotator
extends JCasAnnotator_ImplBase {
    private static final Logger log = LoggerFactory.getLogger(AnnotationAdderAnnotator.class);
    private AnnotationAdderConfiguration adderConfiguration;
    public static final String KEY_ANNOTATION_SOURCE = "AnnotationSource";
    public static final String PARAM_OFFSET_MODE = "OffsetMode";
    public static final String PARAM_DEFAULT_UIMA_TYPE = "DefaultUimaType";
    public static final String PARAM_PREVENT_PROCESSED_MARK = "PreventProcessedMarkOnDigestMismatch";
    @ExternalResource(key="AnnotationSource", description="A provider of annotations to add to the CAS. Must implement the de.julielab.jcore.ae.annotationadder.annotationsources.AnnotationProvider interface.")
    private AnnotationProvider<? extends AnnotationData> annotationProvider;
    @ConfigurationParameter(name="OffsetMode", mandatory=false, description="Determines the interpretation of annotation offsets. Possible values: \"CHARACTER\" and \"TOKEN\". For the TOKEN offset mode, the correct tokenization must be given in the CAS. TOKEN offsets start with 1, CHARACTER offsets are 0-based. Defaults to CHARACTER.", defaultValue={"CHARACTER"})
    private OffsetMode offsetMode;
    @ConfigurationParameter(name="DefaultUimaType", mandatory=false, description="Most external annotation formats require that the qualified name a UIMA type is provided which reflects the annotation to be created for the respective annotation. With this parameter, a default type can be provided which will be forwarded to the format parser. If the parser supports it, the type can then be omitted from the external annotation source.")
    private String defaultUimaType;
    @ConfigurationParameter(name="PreventProcessedMarkOnDigestMismatch", mandatory=false, description="This setting is only in effect if an input format is used that contains document text SHA256 digests while also writing the annotation results into a JeDIS database. If then a CAS document text, to which annotations should be added, does not match the digest given by an annotation, this CAS will not marked as being finished processing by DBCheckpointAE that may follow in the pipeline. The idea is that the mismatched documents require a reprocessing of the original annotation creation algorithm because their text has been changed relative to the annotation on file. By not setting the document as being finished processed, it is straightforward to process only those documents again that failed to add one or multiple annotations.")
    private boolean preventProcessedOnDigestMismatch;
    private List<AnnotationAdder> annotationAdders = Arrays.asList(new TextAnnotationListAdder(), new DocumentClassAnnotationAdder());

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        this.offsetMode = OffsetMode.valueOf(Optional.ofNullable((String)aContext.getConfigParameterValue(PARAM_OFFSET_MODE)).orElse(OffsetMode.CHARACTER.name()));
        this.defaultUimaType = (String)aContext.getConfigParameterValue(PARAM_DEFAULT_UIMA_TYPE);
        this.preventProcessedOnDigestMismatch = Optional.ofNullable((Boolean)aContext.getConfigParameterValue(PARAM_PREVENT_PROCESSED_MARK)).orElse(false);
        try {
            this.annotationProvider = (AnnotationProvider)aContext.getResourceObject(KEY_ANNOTATION_SOURCE);
        }
        catch (ResourceAccessException e) {
            log.error("Could not create the annotation provider", (Throwable)e);
            throw new ResourceInitializationException((Throwable)e);
        }
        this.adderConfiguration = new AnnotationAdderConfiguration();
        this.adderConfiguration.setOffsetMode(this.offsetMode);
        this.adderConfiguration.setDefaultUimaType(this.defaultUimaType);
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        try {
            String docId = JCoReTools.getDocId((JCas)aJCas);
            if (docId == null) {
                log.error("The current document does not have a header. Cannot add external annotations.");
            }
            AnnotationData annotations = this.annotationProvider.getAnnotations(docId);
            AnnotationAdderHelper helper = new AnnotationAdderHelper();
            if (annotations != null) {
                log.trace("Found annotations for document ID {}.", (Object)docId);
                boolean success = false;
                for (int adderNum = 0; adderNum < this.annotationAdders.size() && !(success = this.annotationAdders.get(adderNum).addAnnotations(annotations, helper, this.adderConfiguration, aJCas, this.preventProcessedOnDigestMismatch)); ++adderNum) {
                }
                if (!success) {
                    throw new IllegalArgumentException("There was no annotation adder to handle the annotation data of class " + annotations.getClass().getCanonicalName());
                }
            } else {
                log.debug("No external annotations were delivered for document ID {}", (Object)docId);
            }
        }
        catch (Throwable t) {
            log.error("Could not add annotations due to exception.", t);
            throw new AnalysisEngineProcessException(t);
        }
    }

    public static enum OffsetMode {
        CHARACTER,
        TOKEN;

    }
}

