/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.annotationadder;

import de.julielab.jcore.ae.annotationadder.AnnotationAdderAnnotator;
import de.julielab.jcore.ae.annotationadder.AnnotationAdderConfiguration;
import de.julielab.jcore.ae.annotationadder.AnnotationOffsetException;
import de.julielab.jcore.ae.annotationadder.annotationrepresentations.ExternalTextAnnotation;
import de.julielab.jcore.ae.annotationadder.annotationrepresentations.TextAnnotation;
import de.julielab.jcore.types.Sentence;
import de.julielab.jcore.types.Token;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationAdderHelper {
    private static final Logger log = LoggerFactory.getLogger(AnnotationAdderHelper.class);
    private List<Token> tokenList;
    private Map<Sentence, List<Token>> tokensBySentences;
    private Matcher wsFinder = Pattern.compile("\\s").matcher("");
    private Matcher nonWsMatcher = Pattern.compile("[^\\s]+").matcher("");
    private Map<String, Method> featureSetters;

    public void setAnnotationOffsetsRelativeToDocument(Annotation annotation, TextAnnotation a, AnnotationAdderConfiguration configuration) throws CASException, AnnotationOffsetException {
        if (configuration.getOffsetMode() == AnnotationAdderAnnotator.OffsetMode.CHARACTER) {
            annotation.setBegin(a.getStart());
            annotation.setEnd(a.getEnd());
        } else if (configuration.getOffsetMode() == AnnotationAdderAnnotator.OffsetMode.TOKEN) {
            JCas jCas = annotation.getCAS().getJCas();
            if (!JCasUtil.exists((JCas)jCas, Token.class)) {
                throw new AnnotationOffsetException("The external annotations should be added according to token offset. However, no annotations of type " + Token.class.getCanonicalName() + " are present in the CAS.");
            }
            if (this.tokenList == null) {
                this.tokenList = this.createTokenList(jCas, configuration);
            }
            int startTokenNum = a.getStart();
            int endTokenNum = a.getEnd();
            if (startTokenNum < 1 || startTokenNum > this.tokenList.size()) {
                throw new AnnotationOffsetException("The current annotation to add to the CAS starts at token " + startTokenNum + " which does not fit to the range of tokens in the document which is 1 - " + this.tokenList.size());
            }
            if (endTokenNum < 1 || endTokenNum > this.tokenList.size()) {
                throw new AnnotationOffsetException("The current annotation to add to the CAS ends at token " + endTokenNum + " which does not fit to the range of tokens in the document which is 1 - " + this.tokenList.size());
            }
            if (endTokenNum < startTokenNum) {
                throw new AnnotationOffsetException("The current annotation to add has a lower end offset than start offset. Start: " + startTokenNum + ", end: " + endTokenNum);
            }
            int begin = this.tokenList.get(startTokenNum - 1).getBegin();
            int end = this.tokenList.get(endTokenNum - 1).getEnd();
            annotation.setBegin(begin);
            annotation.setEnd(end);
        }
    }

    public void setAnnotationOffsetsRelativeToSentence(Sentence sentence, Annotation annotation, TextAnnotation a, AnnotationAdderConfiguration configuration) throws CASException, AnnotationOffsetException {
        if (configuration.getOffsetMode() == AnnotationAdderAnnotator.OffsetMode.CHARACTER) {
            annotation.setBegin(sentence.getBegin() + a.getStart());
            annotation.setEnd(sentence.getBegin() + a.getEnd());
        } else if (configuration.getOffsetMode() == AnnotationAdderAnnotator.OffsetMode.TOKEN) {
            JCas jCas = annotation.getCAS().getJCas();
            if (!JCasUtil.exists((JCas)jCas, Token.class)) {
                throw new AnnotationOffsetException("The external annotations should be added according to token offset. However, no annotations of type " + Token.class.getCanonicalName() + " are present in the CAS.");
            }
            if (!JCasUtil.exists((JCas)jCas, Sentence.class)) {
                throw new AnnotationOffsetException("The external annotations should be added according to token offset relative to the sentence containing the tokens. However, no annotations of type " + Sentence.class.getCanonicalName() + " are present in the CAS.");
            }
            this.tokensBySentences = this.createSentenceTokenMap(sentence, configuration);
            List<Token> tokenList = this.tokensBySentences.get(sentence);
            int startTokenNum = a.getStart();
            int endTokenNum = a.getEnd();
            if (startTokenNum < 1 || startTokenNum > tokenList.size()) {
                log.error("Cannot create entity because of a token offset mismatch. The entity should tart at token {} and end at {}. But there are only {} tokens available: {}", new Object[]{startTokenNum, endTokenNum, tokenList.size(), tokenList.stream().map(Annotation::getCoveredText).collect(Collectors.joining(" "))});
                throw new AnnotationOffsetException("The current annotation to add to the CAS starts at token " + startTokenNum + " which does not fit to the range of tokens in the sentence with ID " + sentence.getId() + " which is 1 - " + tokenList.size());
            }
            if (endTokenNum < 1 || endTokenNum > tokenList.size()) {
                throw new AnnotationOffsetException("The current annotation to add to the CAS ends at token " + endTokenNum + " which does not fit to the range of tokens in the sentence with ID " + sentence.getId() + " which is 1 - " + tokenList.size());
            }
            if (endTokenNum < startTokenNum) {
                throw new AnnotationOffsetException("The current annotation to add has a lower end offset than start offset. Start: " + startTokenNum + ", end: " + endTokenNum);
            }
            int begin = tokenList.get(startTokenNum - 1).getBegin();
            int end = tokenList.get(endTokenNum - 1).getEnd();
            annotation.setBegin(begin);
            annotation.setEnd(end);
            if (end > sentence.getCAS().getDocumentText().length()) {
                throw new IllegalStateException("The TextAnnotation " + a + " specifies an end offset that is outside of the document text which has a length of " + sentence.getCAS().getDocumentText().length());
            }
        }
    }

    public Map<Sentence, List<Token>> createSentenceTokenMap(Sentence sentence, AnnotationAdderConfiguration configuration) throws CASException {
        if (this.tokensBySentences != null && this.tokensBySentences.containsKey(sentence)) {
            return this.tokensBySentences;
        }
        HashMap<Sentence, List<Token>> tokensBySentences = new HashMap<Sentence, List<Token>>();
        FSIterator tokenSubiterator = sentence.getCAS().getJCas().getAnnotationIndex(Token.type).subiterator((AnnotationFS)sentence);
        ArrayList<Token> tokens = new ArrayList<Token>();
        while (tokenSubiterator.hasNext()) {
            Token t = (Token)tokenSubiterator.next();
            String tokenText = t.getCoveredText();
            if (configuration.isSplitTokensAtWhitespace()) {
                this.wsFinder.reset(tokenText);
            }
            if (this.wsFinder.find() && configuration.isSplitTokensAtWhitespace()) {
                this.nonWsMatcher.reset(tokenText);
                while (this.nonWsMatcher.find()) {
                    Token subtoken = new Token(sentence.getCAS().getJCas(), t.getBegin() + this.nonWsMatcher.start(), t.getBegin() + this.nonWsMatcher.end());
                    tokens.add(subtoken);
                }
                continue;
            }
            tokens.add(t);
        }
        tokensBySentences.put(sentence, tokens);
        return tokensBySentences;
    }

    public List<Token> createTokenList(JCas jCas, AnnotationAdderConfiguration configuration) {
        if (this.tokenList != null) {
            return this.tokenList;
        }
        ArrayList<Token> tokenList = new ArrayList<Token>();
        FSIterator tokenIt = jCas.getAnnotationIndex(Token.type).iterator(false);
        while (tokenIt.hasNext()) {
            Token t = (Token)tokenIt.next();
            String tokenText = t.getCoveredText();
            if (configuration.isSplitTokensAtWhitespace()) {
                this.wsFinder.reset(tokenText);
            }
            if (this.wsFinder.find() && configuration.isSplitTokensAtWhitespace()) {
                this.nonWsMatcher.reset(tokenText);
                while (this.nonWsMatcher.find()) {
                    Token subtoken = new Token(jCas, t.getBegin() + this.nonWsMatcher.start(), t.getBegin() + this.nonWsMatcher.end());
                    tokenList.add(subtoken);
                }
                continue;
            }
            tokenList.add(t);
        }
        return tokenList;
    }

    public void setAnnotationPayloadsToFeatures(Annotation annotation, ExternalTextAnnotation a) {
        TypeSystem ts = annotation.getCAS().getTypeSystem();
        Collection<String> keys = a.getPayloadKeys();
        if (!keys.isEmpty()) {
            this.featureSetters = new HashMap<String, Method>();
        }
        try {
            for (String key : keys) {
                Object value = a.getPayload(key);
                Method setter = this.featureSetters.get(key);
                if (setter == null) {
                    Class<?> valueClass = this.convertUimaTypeToJavaType(ts.getType(annotation.getClass().getCanonicalName()).getFeatureByBaseName(key).getRange());
                    setter = annotation.getClass().getMethod("set" + StringUtils.capitalize((String)key), valueClass);
                    this.featureSetters.put(key, setter);
                }
                if (setter.getParameterTypes()[0].equals(String.class)) {
                    value = String.valueOf(value);
                }
                setter.invoke((Object)annotation, value);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private Class<?> convertUimaTypeToJavaType(Type type) {
        switch (type.getName()) {
            case "uima.cas.String": {
                return String.class;
            }
            case "uima.cas.Integer": {
                return Integer.TYPE;
            }
            case "uima.cas.Double": {
                return Double.TYPE;
            }
            case "uima.cas.Boolean": {
                return Boolean.TYPE;
            }
            case "uima.cas.Long": {
                return Long.TYPE;
            }
        }
        throw new IllegalArgumentException("Unsupported type for arbitrary feature-based input columns: " + type);
    }
}

