/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.annotationadder;

import de.julielab.jcore.ae.annotationadder.AnnotationAdder;
import de.julielab.jcore.ae.annotationadder.AnnotationAdderConfiguration;
import de.julielab.jcore.ae.annotationadder.AnnotationAdderHelper;
import de.julielab.jcore.ae.annotationadder.annotationrepresentations.AnnotationData;
import de.julielab.jcore.ae.annotationadder.annotationrepresentations.AnnotationList;
import de.julielab.jcore.ae.annotationadder.annotationrepresentations.ExternalDocumentClassAnnotation;
import de.julielab.jcore.types.AutoDescriptor;
import de.julielab.jcore.types.DocumentClass;
import de.julielab.jcore.utility.JCoReTools;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentClassAnnotationAdder
implements AnnotationAdder {
    private static final Logger log = LoggerFactory.getLogger(DocumentClassAnnotationAdder.class);

    @Override
    public boolean addAnnotations(AnnotationData data, AnnotationAdderHelper helper, AnnotationAdderConfiguration configuration, JCas jCas, boolean preventProcessedOnDigestMismatch) {
        AnnotationList annotationList;
        try {
            annotationList = (AnnotationList)data;
            if (!annotationList.isEmpty()) {
                ExternalDocumentClassAnnotation externalDocumentClassAnnotation = (ExternalDocumentClassAnnotation)annotationList.get(0);
            }
        }
        catch (ClassCastException e) {
            log.debug("AnnotationList adder rejected annotation data of class {}", (Object)data.getClass().getCanonicalName());
            return false;
        }
        for (ExternalDocumentClassAnnotation a : annotationList) {
            AutoDescriptor ad;
            try {
                ad = (AutoDescriptor)JCasUtil.selectSingle((JCas)jCas, AutoDescriptor.class);
            }
            catch (IllegalArgumentException e) {
                ad = new AutoDescriptor(jCas);
                ad.addToIndexes();
            }
            DocumentClass documentClass = new DocumentClass(jCas);
            documentClass.setClassname(a.getDocumentClass());
            documentClass.setConfidence(a.getConfidence());
            documentClass.setComponentId(a.getComponentId());
            FSArray newArray = JCoReTools.addToFSArray((FSArray)ad.getDocumentClasses(), (FeatureStructure)documentClass, (int)1);
            ad.setDocumentClasses(newArray);
        }
        return true;
    }
}

