/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.annotationadder;

import de.julielab.jcore.ae.annotationadder.AnnotationAdder;
import de.julielab.jcore.ae.annotationadder.AnnotationAdderAnnotator;
import de.julielab.jcore.ae.annotationadder.AnnotationAdderConfiguration;
import de.julielab.jcore.ae.annotationadder.AnnotationAdderHelper;
import de.julielab.jcore.ae.annotationadder.AnnotationOffsetException;
import de.julielab.jcore.ae.annotationadder.annotationrepresentations.AnnotationData;
import de.julielab.jcore.ae.annotationadder.annotationrepresentations.AnnotationList;
import de.julielab.jcore.ae.annotationadder.annotationrepresentations.ExternalTextAnnotation;
import de.julielab.jcore.types.ext.DBProcessingMetaData;
import de.julielab.jcore.utility.JCoReAnnotationTools;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.uima.cas.CASException;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextAnnotationListAdder
implements AnnotationAdder {
    private static final Logger log = LoggerFactory.getLogger(TextAnnotationListAdder.class);

    @Override
    public boolean addAnnotations(AnnotationData data, AnnotationAdderHelper helper, AnnotationAdderConfiguration configuration, JCas jCas, boolean preventProcessedOnDigestMismatch) {
        AnnotationList annotationList;
        try {
            annotationList = (AnnotationList)data;
            if (!annotationList.isEmpty()) {
                ExternalTextAnnotation externalTextAnnotation = (ExternalTextAnnotation)annotationList.get(0);
            }
        }
        catch (ClassCastException e) {
            log.debug("AnnotationList adder rejected annotation data of class {}", (Object)data.getClass().getCanonicalName());
            return false;
        }
        String jCasDocTextSha = null;
        boolean shaMismatchWasReported = false;
        for (ExternalTextAnnotation a : annotationList) {
            String uimaType;
            if (a.getUimaType() != null && jCas.getTypeSystem().getType(a.getUimaType()) != null) {
                uimaType = a.getUimaType();
            } else if (configuration.getDefaultUimaType() != null) {
                uimaType = configuration.getDefaultUimaType();
            } else {
                throw new IllegalArgumentException("Missing annotation type: Neither the annotation of document " + a.getDocumentId() + " with offsets " + a.getStart() + "-" + a.getEnd() + " provides a type nor is the default type set.");
            }
            if (jCas.getTypeSystem().getType(uimaType) == null) {
                throw new IllegalArgumentException("The entity annotation type " + uimaType + " does not exist in the type system.");
            }
            try {
                String shaFromAnnotation = (String)a.getPayload("sha");
                boolean shaMatches = true;
                if (shaFromAnnotation != null) {
                    if (jCasDocTextSha == null) {
                        byte[] bytes = DigestUtils.sha256((String)jCas.getDocumentText());
                        jCasDocTextSha = Base64.encodeBase64String((byte[])bytes);
                    }
                    shaMatches = jCasDocTextSha.equals(shaFromAnnotation);
                }
                if (shaMatches) {
                    if (a.getStart() >= 0) {
                        Annotation annotation = JCoReAnnotationTools.getAnnotationByClassName((JCas)jCas, (String)uimaType);
                        if (annotation instanceof de.julielab.jcore.types.Annotation) {
                            ((de.julielab.jcore.types.Annotation)annotation).setComponentId(AnnotationAdderAnnotator.class.getSimpleName());
                        }
                        helper.setAnnotationOffsetsRelativeToDocument(annotation, a, configuration);
                        helper.setAnnotationPayloadsToFeatures(annotation, a);
                        log.trace("Adding annotation of type {} with offsets {}-{} to document with ID {}", new Object[]{uimaType, annotation.getBegin(), annotation.getEnd(), annotationList.getDocId()});
                        annotation.addToIndexes();
                        continue;
                    }
                    log.trace("ExternalAnnotation for document {} has no entity offsets or offsets < 0, not adding anything to the CAS.", (Object)a.getDocumentId());
                    continue;
                }
                if (shaMismatchWasReported) continue;
                log.warn("The document with ID '{}' has a differing document text hash from a given annotation. The annotation will not be added to the document. Annotation hash: {}, current document text hash: {}", new Object[]{annotationList.getDocId(), shaFromAnnotation, jCasDocTextSha});
                shaMismatchWasReported = true;
                if (!preventProcessedOnDigestMismatch) continue;
                try {
                    DBProcessingMetaData dbProcessingMetaData = (DBProcessingMetaData)JCasUtil.selectSingle((JCas)jCas, DBProcessingMetaData.class);
                    dbProcessingMetaData.setDoNotMarkAsProcessed(true);
                }
                catch (IllegalArgumentException e) {
                    log.error("Could not acquire the DBProcessingMetaData to exclude the hash-mismatched document from being marked as being processed in the JeDIS database. This annotation should have been set by the jcore-(xmi)-db-reader. Does this pipeline read from a JeDIS subset table?");
                }
            }
            catch (AnnotationOffsetException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | CASException e) {
                e.printStackTrace();
            }
        }
        return true;
    }
}

