/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.annotationadder.annotationformat;

import de.julielab.jcore.ae.annotationadder.annotationformat.AnnotationFormat;
import de.julielab.jcore.ae.annotationadder.annotationrepresentations.ExternalDocumentClassAnnotation;
import java.util.List;

public class DocumentClassAnnotationFormat
implements AnnotationFormat<ExternalDocumentClassAnnotation> {
    @Override
    public ExternalDocumentClassAnnotation parse(String data) {
        if (data == null || data.startsWith("#")) {
            return null;
        }
        String[] record = data.split("\t");
        if (record.length < 4) {
            throw new IllegalArgumentException("Expected a 4-column format providing class assignment confidence, document ID, the class assigned and the assigning component ID and UIMA type (optional if the default type is set to the AnnotationAdderAnnotator) for the annotation but got " + record.length + " columns: " + data);
        }
        double confidence = Double.valueOf(record[0]);
        String docId = record[1];
        String documentClass = record[2].intern();
        String componentId = record[3].intern();
        return new ExternalDocumentClassAnnotation(docId, documentClass, confidence, componentId);
    }

    @Override
    public void hasHeader(boolean withHeader) {
    }

    @Override
    public String[] getHeader() {
        return new String[]{"confidence", "docId", "documentClass", "componentId"};
    }

    @Override
    public List<Class<?>> getColumnDataTypes() {
        return List.of(Double.class, String.class, String.class, String.class);
    }

    @Override
    public void setColumnNames(String[] header) {
    }

    @Override
    public int getDocumentIdColumnIndex() {
        return 1;
    }
}

