/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.annotationadder.annotationformat;

import de.julielab.jcore.ae.annotationadder.annotationformat.AnnotationFormat;
import de.julielab.jcore.ae.annotationadder.annotationrepresentations.ExternalTextAnnotation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureBasedTSVFormat
implements AnnotationFormat<ExternalTextAnnotation> {
    private static final Logger log = LoggerFactory.getLogger(FeatureBasedTSVFormat.class);
    private String[] header;
    private boolean withHeader;
    private Integer uimaTypeIndex;
    private List<Class<?>> columnDataTypes;

    @Override
    public ExternalTextAnnotation parse(String data) {
        if (data == null || data.startsWith("#")) {
            return null;
        }
        String[] record = data.split("\t");
        if (record.length < 3) {
            throw new IllegalArgumentException("Expected at least 3 column format providing document ID, begin and end offset for the annotation but got " + record.length + " columns: " + data);
        }
        if (this.withHeader && this.header == null) {
            this.header = record;
            return null;
        }
        if (this.columnDataTypes == null) {
            this.columnDataTypes = new ArrayList(this.header.length);
        }
        if (this.uimaTypeIndex == null) {
            this.uimaTypeIndex = -1;
            for (int i = 0; i < this.header.length; ++i) {
                if (!this.header[i].equals("uimaType")) continue;
                this.uimaTypeIndex = i;
            }
            if (this.uimaTypeIndex == 0) {
                throw new IllegalArgumentException("Found the uima_type column at index 0. However, the first column is reserved for the document ID.");
            }
        }
        if (this.columnDataTypes.isEmpty()) {
            this.determineColumnDataTypes(record);
        }
        String docId = record[0];
        String type = this.uimaTypeIndex >= 0 ? record[this.uimaTypeIndex] : null;
        ExternalTextAnnotation externalTextAnnotation = new ExternalTextAnnotation(docId, 0, 0, type);
        externalTextAnnotation.setPayloadFeatureValues(true);
        for (int i = 1; i < Math.min(this.header.length, record.length); ++i) {
            String featureName = this.header[i];
            String columnValue = record[i];
            if (featureName.equals("uimaType")) continue;
            externalTextAnnotation.addPayload(featureName, this.convertValueToFieldDataType(columnValue, i));
        }
        return externalTextAnnotation;
    }

    private Object convertValueToFieldDataType(String columnValue, int columnIndex) {
        Class<?> columnDataType = this.columnDataTypes.get(columnIndex);
        if (columnDataType.equals(Integer.class)) {
            return Integer.parseInt(columnValue);
        }
        if (columnDataType.equals(Double.class)) {
            return Double.parseDouble(columnValue);
        }
        if (columnDataType.equals(Boolean.class)) {
            return Boolean.parseBoolean(columnValue);
        }
        return columnValue.intern();
    }

    private void determineColumnDataTypes(String[] record) {
        for (int i = 0; i < record.length; ++i) {
            String value = record[i];
            Class<?> dataType = this.determineDataType(value);
            this.columnDataTypes.add(dataType);
        }
        log.info("Identified the data types of columns {} as {}", (Object)this.header, this.columnDataTypes);
    }

    @Override
    public void hasHeader(boolean withHeader) {
        this.withHeader = withHeader;
    }

    @Override
    public String[] getHeader() {
        return this.header;
    }

    @Override
    public List<Class<?>> getColumnDataTypes() {
        if (this.columnDataTypes == null) {
            throw new IllegalStateException("The column data types are not yet set. This call must come after the first line of data has been read.");
        }
        return this.columnDataTypes;
    }

    @Override
    public void setColumnNames(String[] header) {
        this.header = header;
    }

    @Override
    public int getDocumentIdColumnIndex() {
        return 0;
    }
}

