/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.annotationadder.annotationformat;

import de.julielab.jcore.ae.annotationadder.annotationformat.AnnotationFormat;
import de.julielab.jcore.ae.annotationadder.annotationrepresentations.ExternalTextAnnotation;
import java.util.List;

public class SimpleTSVEntityWithDocumentTextShaAnnotationFormat
implements AnnotationFormat<ExternalTextAnnotation> {
    private List<Class<?>> columnDataTypes;

    @Override
    public ExternalTextAnnotation parse(String data) {
        if (data == null || data.startsWith("#")) {
            return null;
        }
        String[] record = data.split("\t");
        if (record.length < 4) {
            throw new IllegalArgumentException("Expected a 4 or 5-column format providing document ID, begin, end, sha-hash and UIMA type (optional if the default type is set to the AnnotationAdderAnnotator) for the annotation but got " + record.length + " columns: " + data);
        }
        String docId = record[0].intern();
        int begin = !record[1].isBlank() ? Integer.parseInt(record[1]) : -1;
        int end = !record[2].isBlank() ? Integer.parseInt(record[2]) : -1;
        String sha = record[3].intern();
        String type = null;
        if (record.length > 4) {
            type = record[4].intern();
        }
        if (this.columnDataTypes == null) {
            this.columnDataTypes = List.of(String.class, Integer.class, Integer.class, String.class, String.class);
        }
        ExternalTextAnnotation externalTextAnnotation = new ExternalTextAnnotation(docId, begin, end, type);
        externalTextAnnotation.addPayload("sha", sha);
        return externalTextAnnotation;
    }

    @Override
    public void hasHeader(boolean withHeader) {
    }

    @Override
    public String[] getHeader() {
        return new String[]{"docId", "beginOffset", "endOffset", "sha", "uimaType"};
    }

    @Override
    public List<Class<?>> getColumnDataTypes() {
        if (this.columnDataTypes == null) {
            throw new IllegalStateException("The column data types are not yet set. This call must come after the first line of data has been read.");
        }
        return this.columnDataTypes;
    }

    @Override
    public void setColumnNames(String[] header) {
    }

    @Override
    public int getDocumentIdColumnIndex() {
        return 0;
    }
}

