/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.annotationadder.annotationsources;

import de.julielab.java.utilities.UriUtilities;
import de.julielab.jcore.ae.annotationadder.annotationformat.AnnotationFormat;
import de.julielab.jcore.ae.annotationadder.annotationrepresentations.AnnotationData;
import de.julielab.jcore.ae.annotationadder.annotationrepresentations.AnnotationList;
import de.julielab.jcore.ae.annotationadder.annotationrepresentations.ExternalDocumentClassAnnotation;
import de.julielab.jcore.ae.annotationadder.annotationrepresentations.ExternalTextAnnotation;
import de.julielab.jcore.ae.annotationadder.annotationsources.AnnotationSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.uima.resource.DataResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2AnnotationSource<T extends AnnotationData>
implements AnnotationSource<AnnotationList<T>> {
    private static final Logger log = LoggerFactory.getLogger(H2AnnotationSource.class);
    private AnnotationFormat<T> format;
    private Path h2DbPath;
    private Statement queryStmt;
    private Class<?> annotationDataClass;

    public H2AnnotationSource(AnnotationFormat<T> format) {
        this.format = format;
        if (format.getHeader() == null) {
            throw new IllegalArgumentException("To use the H2AnnotationSource, the input format must define the column headers. The employed format " + format + " does not specify them itself. Thus, the header must be specified in the component descriptor external resource definition.");
        }
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            log.error("Could not load the h2 Driver through 'Class.forName(\"org.h2.Driver\").");
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void loadAnnotations(URI annotationUri) throws IOException {
        Path annotationFilePath = annotationUri.toString().contains("file:" + File.separator) ? Path.of(annotationUri) : Path.of(annotationUri.toString().replace("file:", ""), new String[0]);
        Path path = this.h2DbPath = annotationFilePath.isAbsolute() ? Path.of(annotationFilePath + ".h2", new String[0]) : Path.of("." + File.separator + annotationFilePath + ".h2", new String[0]);
        if (!Files.exists(this.h2DbPath, new LinkOption[0]) || Files.getLastModifiedTime(annotationFilePath, new LinkOption[0]).toMillis() < Files.getLastModifiedTime(this.h2DbPath, new LinkOption[0]).toMillis()) {
            log.info("Source annotation file {} is newer than database file {}. Creating a new database.", (Object)annotationFilePath, (Object)this.h2DbPath);
            Files.list(this.h2DbPath.getParent()).filter(p -> p.toString().startsWith(this.h2DbPath.toString())).forEach(p -> FileUtils.deleteQuietly((File)p.toFile()));
            try (Connection conn = DriverManager.getConnection("jdbc:h2:" + this.h2DbPath, "sa", "");){
                conn.setAutoCommit(false);
                Statement ps = null;
                HashMap columnIndexes = new HashMap();
                try (BufferedReader br = UriUtilities.getReaderFromUri((URI)annotationUri);){
                    Iterator iterator = br.lines().map(this.format::parse).filter(Objects::nonNull).iterator();
                    boolean firstDataItem = true;
                    int psSize = 0;
                    int linesRead = 0;
                    while (iterator.hasNext()) {
                        ++linesRead;
                        AnnotationData annotationData = (AnnotationData)iterator.next();
                        if (firstDataItem) {
                            for (int i2 = 0; i2 < this.format.getHeader().length; ++i2) {
                                if (this.format.getHeader()[i2].equals("begin")) {
                                    this.format.getHeader()[i2] = "beginOffset";
                                    continue;
                                }
                                if (!this.format.getHeader()[i2].equals("end")) continue;
                                this.format.getHeader()[i2] = "endOffset";
                            }
                            IntStream.range(0, this.format.getHeader().length).forEach(i -> columnIndexes.put(this.format.getHeader()[i], i));
                            this.annotationDataClass = annotationData.getClass();
                            this.createAnnotationTable(conn, annotationData);
                            String insertionSql = "INSERT INTO annotations VALUES (" + IntStream.range(0, this.format.getHeader().length).mapToObj(i -> "?").collect(Collectors.joining(",")) + ")";
                            ps = conn.prepareStatement(insertionSql);
                            firstDataItem = false;
                        }
                        if (annotationData instanceof ExternalDocumentClassAnnotation) {
                            throw new NotImplementedException("ExternalDocumentClassAnnotation data is currently not supprted by the H2AnnotationSource.");
                        }
                        ExternalTextAnnotation textAnnotation = (ExternalTextAnnotation)annotationData;
                        Map<String, Object> fieldValues = textAnnotation.getAllFieldValuesAsMap();
                        for (String columnName : this.format.getHeader()) {
                            ps.setObject((Integer)columnIndexes.get(columnName) + 1, fieldValues.get(columnName));
                        }
                        ps.addBatch();
                        if (++psSize % 50 == 0) {
                            ps.executeBatch();
                        }
                        if (psSize % 10000 == 0 && log.isTraceEnabled()) {
                            int numRows = this.getCount(conn, "SELECT count(*) FROM annotations");
                            int numDocIds = this.getCount(conn, "SELECT count(DISTINCT docId) FROM annotations");
                            log.trace("Loaded {} entity annotations for {} document IDs.", (Object)numRows, (Object)numDocIds);
                        }
                        if (linesRead % 10000 != 0 || !log.isTraceEnabled()) continue;
                        log.trace("Read {} lines from input {}", (Object)linesRead, (Object)annotationUri);
                    }
                    if (psSize > 0) {
                        ps.executeBatch();
                    }
                }
                if (log.isTraceEnabled()) {
                    int numRows = this.getCount(conn, "SELECT count(*) FROM annotations");
                    int numDocIds = this.getCount(conn, "SELECT count(DISTINCT docId) FROM annotations");
                    log.trace("Loaded {} entity annotations for {} document IDs.", (Object)numRows, (Object)numDocIds);
                }
                conn.commit();
            }
            catch (SQLException e) {
                log.error("Could not create H2 database at {}", (Object)this.h2DbPath);
                throw new IllegalStateException(e);
            }
        }
    }

    private int getCount(Connection conn, String sql) {
        try {
            ResultSet rs = conn.createStatement().executeQuery(sql);
            if (rs.next()) {
                return rs.getInt(1);
            }
        }
        catch (SQLException e) {
            log.error("Could not count rows via SQL query {}", (Object)sql, (Object)e);
            throw new IllegalStateException(e);
        }
        return 0;
    }

    private void createAnnotationTable(Connection conn, T annotationData) throws SQLException {
        Statement stmt = conn.createStatement();
        String tableCreationSql = this.getTableCreationSql(this.format.getHeader(), this.format.getColumnDataTypes(), annotationData);
        try {
            stmt.execute(tableCreationSql);
        }
        catch (SQLException e) {
            log.error("Could not create the annotation SQL table with command {}", (Object)tableCreationSql, (Object)e);
            throw new IllegalStateException(e);
        }
        String indexCreationSql = "CREATE INDEX annotations_doc_id_idx ON annotations (" + this.format.getHeader()[this.format.getDocumentIdColumnIndex()] + ")";
        try {
            stmt.execute(indexCreationSql);
        }
        catch (SQLException e) {
            log.error("Could not create index on document ID column which should be found at index {} of the header {} with SQL {}.", new Object[]{this.format.getDocumentIdColumnIndex(), this.format.getHeader(), indexCreationSql, e});
            throw new IllegalStateException(e);
        }
    }

    private String getTableCreationSql(String[] header, List<Class<?>> columnDataTypes, T annotationData) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE annotations (");
        for (int i = 0; i < header.length; ++i) {
            String columnName = header[i];
            Class<?> dataType = columnDataTypes.get(i);
            String dbDataType = this.getDbDataType(dataType);
            sb.append(columnName).append(" ").append(dbDataType);
            if (i >= header.length - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private String getDbDataType(Class<?> dataType) {
        if (dataType.equals(Integer.class)) {
            return "INT";
        }
        if (dataType.equals(Double.class)) {
            return "DOUBLE";
        }
        if (dataType.equals(Boolean.class)) {
            return "BOOL";
        }
        return "VARCHAR";
    }

    @Override
    public void initialize(DataResource dataResource) throws IOException {
        log.info("Loading entity annotations from {}", (Object)dataResource.getUri());
        this.loadAnnotations(dataResource.getUri());
    }

    @Override
    public AnnotationList<T> getAnnotations(String id) {
        try {
            if (this.queryStmt == null) {
                Connection queryConn = DriverManager.getConnection("jdbc:h2:" + this.h2DbPath, "sa", "");
                this.queryStmt = queryConn.createStatement();
            }
        }
        catch (SQLException e) {
            log.error("Could not connect to database at {}", (Object)this.h2DbPath, (Object)e);
            throw new IllegalStateException(e);
        }
        String sql = "SELECT * FROM annotations WHERE docId='" + id + "'";
        try {
            ResultSet rs = this.queryStmt.executeQuery(sql);
            AnnotationList<AnnotationData> annotationList = new AnnotationList<AnnotationData>();
            while (rs.next()) {
                AnnotationData textAnnotation = null;
                if (this.annotationDataClass == null) {
                    throw new IllegalStateException("The annotation data class should have been recorded when data was read from file but it is null.");
                }
                try {
                    if (!this.annotationDataClass.equals(ExternalTextAnnotation.class)) {
                        throw new NotImplementedException("The annotation class " + this.annotationDataClass + " is currently not supported by the H2AnnotationSource.");
                    }
                    textAnnotation = (AnnotationData)this.annotationDataClass.getConstructor(String.class, Integer.TYPE, Integer.TYPE, String.class).newInstance(rs.getString("docId"), rs.getInt("beginOffset"), rs.getInt("endOffset"), rs.getString("uimaType"));
                }
                catch (Exception e) {
                    log.error("Could not create instance of annotation data class {}", this.annotationDataClass, (Object)e);
                }
                for (String columnName : this.format.getHeader()) {
                    Object value = rs.getObject(columnName);
                    if (value == null || !(textAnnotation instanceof ExternalTextAnnotation) || columnName.equals("uimaType") || columnName.equals("docId")) continue;
                    ExternalTextAnnotation a = (ExternalTextAnnotation)textAnnotation;
                    String payLoadKey = columnName;
                    if (payLoadKey.equals("beginOffset")) {
                        payLoadKey = "begin";
                    } else if (payLoadKey.equals("endOffset")) {
                        payLoadKey = "end";
                    }
                    a.addPayload(payLoadKey, value);
                }
                annotationList.add(textAnnotation);
            }
            return annotationList;
        }
        catch (SQLException e) {
            log.error("Could not retrieve annotation values from the H2 database via SQL query '{}'", (Object)sql);
            throw new IllegalStateException(e);
        }
    }
}

