/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.annotationadder.annotationsources;

import de.julielab.java.utilities.UriUtilities;
import de.julielab.jcore.ae.annotationadder.annotationformat.AnnotationFormat;
import de.julielab.jcore.ae.annotationadder.annotationrepresentations.AnnotationData;
import de.julielab.jcore.ae.annotationadder.annotationrepresentations.AnnotationList;
import de.julielab.jcore.ae.annotationadder.annotationsources.AnnotationSource;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.uima.resource.DataResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryAnnotationSource<T extends AnnotationData>
implements AnnotationSource<AnnotationList<T>> {
    private static final Logger log = LoggerFactory.getLogger(InMemoryAnnotationSource.class);
    private AnnotationFormat<T> format;
    private Map<String, AnnotationList<T>> entitiesByDocId;

    public InMemoryAnnotationSource(AnnotationFormat<T> format) {
        this.format = format;
    }

    @Override
    public void loadAnnotations(URI annotationUri) throws IOException {
        try (BufferedReader br = UriUtilities.getReaderFromUri((URI)annotationUri);){
            this.entitiesByDocId = br.lines().map(this.format::parse).filter(Objects::nonNull).collect(Collectors.groupingBy(AnnotationData::getDocumentId, Collectors.toCollection(AnnotationList::new)));
        }
        if (log.isTraceEnabled()) {
            log.trace("Loaded {} entity annotations for {} document IDs.", (Object)this.entitiesByDocId.values().stream().flatMap(Collection::stream).count(), (Object)this.entitiesByDocId.size());
        }
    }

    @Override
    public void initialize(DataResource dataResource) throws IOException {
        log.info("Loading entity annotations from {}", (Object)dataResource.getUri());
        this.loadAnnotations(dataResource.getUri());
    }

    @Override
    public AnnotationList<T> getAnnotations(String id) {
        return this.entitiesByDocId.get(id);
    }
}

