/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.annotationadder.annotationsources;

import de.julielab.jcore.ae.annotationadder.annotationformat.AnnotationFormat;
import de.julielab.jcore.ae.annotationadder.annotationformat.SimpleTSVEntityAnnotationFormat;
import de.julielab.jcore.ae.annotationadder.annotationrepresentations.AnnotationList;
import de.julielab.jcore.ae.annotationadder.annotationrepresentations.ExternalTextAnnotation;
import de.julielab.jcore.ae.annotationadder.annotationsources.AnnotationProvider;
import de.julielab.jcore.ae.annotationadder.annotationsources.AnnotationSource;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import org.apache.uima.resource.DataResource;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.slf4j.Logger;

public abstract class TextAnnotationProvider
implements AnnotationProvider<AnnotationList> {
    public static final String PARAM_ANNOTATION_FORMAT = "AnnotationFormatClass";
    public static final String PARAM_INPUT_HAS_HEADER = "InputHasHeader";
    public static final String PARAM_COLUMN_NAMES = "ColumnNames";
    public static final String COL_DOC_ID = "docId";
    public static final String COL_BEGIN = "beginOffset";
    public static final String COL_END = "endOffset";
    public static final String COL_UIMA_TYPE = "uimaType";
    protected Logger log;
    protected AnnotationSource<AnnotationList<ExternalTextAnnotation>> annotationSource;
    protected AnnotationFormat<ExternalTextAnnotation> format;

    @Override
    public AnnotationList<ExternalTextAnnotation> getAnnotations(String id) {
        return this.annotationSource.getAnnotations(id);
    }

    abstract void initializeAnnotationSource();

    abstract Logger getLogger();

    public void load(DataResource dataResource) throws ResourceInitializationException {
        ConfigurationParameterSettings parameterSettings = dataResource.getMetaData().getConfigurationParameterSettings();
        String formatClassName = (String)Optional.ofNullable(parameterSettings.getParameterValue(PARAM_ANNOTATION_FORMAT)).orElse(SimpleTSVEntityAnnotationFormat.class.getCanonicalName());
        boolean hasHeader = (Boolean)Optional.ofNullable(parameterSettings.getParameterValue(PARAM_INPUT_HAS_HEADER)).orElse(false);
        String[] columnNames = (String[])parameterSettings.getParameterValue(PARAM_COLUMN_NAMES);
        try {
            this.format = (AnnotationFormat)Class.forName(formatClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.format.hasHeader(hasHeader);
            this.format.setColumnNames(columnNames);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            this.getLogger().error("Could not instantiate class {}", (Object)formatClassName);
            throw new ResourceInitializationException((Throwable)e);
        }
        this.initializeAnnotationSource();
        try {
            this.annotationSource.initialize(dataResource);
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }
}

