/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.dta;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.ximpleware.ParseException;
import com.ximpleware.VTDNav;
import de.julielab.jcore.reader.dta.PersonType;
import de.julielab.jcore.reader.dta.mapping.MappingService;
import de.julielab.jcore.types.Lemma;
import de.julielab.jcore.types.STTSPOSTag;
import de.julielab.jcore.types.Sentence;
import de.julielab.jcore.types.Token;
import de.julielab.jcore.types.extensions.dta.Header;
import de.julielab.jcore.types.extensions.dta.PersonInfo;
import de.julielab.xml.JulieXMLTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DTAFileReader
extends CollectionReader_ImplBase {
    static final String COMPONENT_ID = DTAFileReader.class.getCanonicalName();
    public static final String PARAM_INPUTFILE = "inputFile";
    public static final String PARAM_NORMALIZE = "normalize";
    public static final String PARAM_FORMAT_2017 = "format2017";
    private static final String XPATH_TEXT_CORPUS = "/D-Spin/TextCorpus/";
    private static final String XPATH_TEI_HEADER_2016 = "/D-Spin/MetaData/source/CMD/Components/teiHeader/";
    private static final String XPATH_TEI_HEADER_2017 = "/D-Spin/MetaData/source/cmd:CMD/cmd:Components/cmdp:teiHeader/";
    private static final String XPATH_PROFILE_DESC_2016 = "/D-Spin/MetaData/source/CMD/Components/teiHeader/profileDesc/";
    private static final String XPATH_PROFILE_DESC_2017 = "/D-Spin/MetaData/source/cmd:CMD/cmd:Components/cmdp:teiHeader/cmdp:profileDesc/";
    private static final String XPATH_TITLE_STMT_2016 = "/D-Spin/MetaData/source/CMD/Components/teiHeader/fileDesc/titleStmt/";
    private static final String XPATH_TITLE_STMT_2017 = "/D-Spin/MetaData/source/cmd:CMD/cmd:Components/cmdp:teiHeader/cmdp:fileDesc/cmdp:titleStmt/";
    static final String XPATH_PUBLICATION_STMT_2016 = "/D-Spin/MetaData/source/CMD/Components/teiHeader/fileDesc/sourceDesc/biblFull/publicationStmt/";
    static final String XPATH_PUBLICATION_STMT_2017 = "/D-Spin/MetaData/source/cmd:CMD/cmd:Components/cmdp:teiHeader/cmdp:fileDesc/cmdp:sourceDesc/cmdp:biblFull/cmdp:publicationStmt/";
    private static final String XPATH_YEAR_2016 = "/D-Spin/MetaData/source/CMD/Components/teiHeader/fileDesc/sourceDesc/biblFull/publicationStmt/date";
    private static final String XPATH_YEAR_2017 = "/D-Spin/MetaData/source/cmd:CMD/cmd:Components/cmdp:teiHeader/cmdp:fileDesc/cmdp:sourceDesc/cmdp:biblFull/cmdp:publicationStmt/cmdp:date";
    private static final Logger LOGGER = LoggerFactory.getLogger(DTAFileReader.class);
    private static final Joiner NEW_LINE_JOINER = Joiner.on((String)"\n");
    private final List<File> inputFiles = new ArrayList<File>();
    private int counter = 0;
    private boolean format2017 = true;
    private boolean normalize = true;

    static boolean formatIsOk(String xmlFileName, VTDNav nav, boolean xpath2017) {
        for (String tagset : DTAFileReader.mapAttribute2Text(xmlFileName, nav, "/D-Spin/TextCorpus/POStags", "@tagset").keySet()) {
            if (tagset.equals("stts")) continue;
            return false;
        }
        String langXpath = xpath2017 ? "/D-Spin/MetaData/source/cmd:CMD/cmd:Components/cmdp:teiHeader/cmdp:profileDesc/cmdp:langUsage/cmdp:language" : "/D-Spin/MetaData/source/CMD/Components/teiHeader/profileDesc/langUsage/language";
        for (String[] language : DTAFileReader.mapAttribute2Text(xmlFileName, nav, langXpath, ".").values()) {
            if (language.length == 1 && language[0].equals("German")) continue;
            return false;
        }
        return true;
    }

    static Iterable<String> getAttributeForEach(final String xmlFileName, final VTDNav nav, final String forEachXpath, final String attributeXpath) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    final String text = "text";
                    final String attribute = "attribute";
                    final List<Map<String, String>> fields = new ArrayList<Map<String, String>>();
                    final Iterator<Map<String, Object>> tokenIterator;
                    {
                        this.fields.add((Map<String, String>)ImmutableMap.of((Object)"name", (Object)"text", (Object)"xpath", (Object)"."));
                        this.fields.add((Map<String, String>)ImmutableMap.of((Object)"name", (Object)"attribute", (Object)"xpath", (Object)attributeXpath));
                        this.tokenIterator = JulieXMLTools.constructRowIterator((VTDNav)nav, (String)forEachXpath, this.fields, (String)xmlFileName);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.tokenIterator.hasNext();
                    }

                    @Override
                    public String next() {
                        return (String)this.tokenIterator.next().get("attribute");
                    }

                    @Override
                    public void remove() {
                        throw new IllegalAccessError();
                    }
                };
            }
        };
    }

    private static String getEntry(String xmlFile, String id, Map<String, String[]> map1) {
        return DTAFileReader.getEntry(xmlFile, id, map1, null);
    }

    private static String getEntry(String xmlFile, String id, Map<String, String[]> backupMap, Map<String, String[]> preferredMap) {
        String[] s;
        if (preferredMap != null && (s = preferredMap.get(id)) != null) {
            if (s.length != 1) {
                throw new IllegalArgumentException("ID \"" + id + "\" has not exactly one entry in " + xmlFile);
            }
            return s[0];
        }
        s = backupMap.get(id);
        if (s == null) {
            throw new IllegalArgumentException("ID \"" + id + "\" has no associated entry in " + xmlFile);
        }
        if (s.length != 1) {
            throw new IllegalArgumentException("ID \"" + id + "\" has not exactly one entry in " + xmlFile);
        }
        return s[0];
    }

    static FSArray getPersons(JCas jcas, VTDNav vn, String xmlFileName, PersonType personType, boolean xpath2017) {
        ArrayList<PersonInfo> personList = new ArrayList<PersonInfo>();
        String forEachXpath = xpath2017 ? "/D-Spin/MetaData/source/cmd:CMD/cmd:Components/cmdp:teiHeader/cmdp:fileDesc/cmdp:titleStmt/cmdp:" + (Object)((Object)personType) + "/cmdp:persName" : XPATH_TITLE_STMT_2016 + (Object)((Object)personType) + "/persName";
        ArrayList<ImmutableMap> fields = new ArrayList<ImmutableMap>();
        fields.add(ImmutableMap.of((Object)"name", (Object)"surname", (Object)"xpath", (Object)(xpath2017 ? "cmdp:surname" : "surname")));
        fields.add(ImmutableMap.of((Object)"name", (Object)"forename", (Object)"xpath", (Object)(xpath2017 ? "cmdp:forename" : "forename")));
        fields.add(ImmutableMap.of((Object)"name", (Object)"idno", (Object)"xpath", (Object)(xpath2017 ? "cmdp:idno/cmdp:idno[@type='PND']" : " idno/idno[@type='PND']")));
        Iterator iterator = JulieXMLTools.constructRowIterator((VTDNav)vn, (String)forEachXpath, fields, (String)xmlFileName);
        while (iterator.hasNext()) {
            PersonInfo person = new PersonInfo(jcas);
            Map row = (Map)iterator.next();
            person.setSurename((String)row.get("surname"));
            person.setForename((String)row.get("forename"));
            person.setIdno((String)row.get("idno"));
            person.addToIndexes();
            personList.add(person);
        }
        FSArray personArray = new FSArray(jcas, personList.size());
        personArray.copyFromArray((FeatureStructure[])personList.toArray(new PersonInfo[personList.size()]), 0, 0, personList.size());
        personArray.addToIndexes();
        return personArray;
    }

    static List<String> getTexts(String xmlFileName, VTDNav nav, String forEachXpath) {
        ArrayList<String> texts = new ArrayList<String>();
        String text = "text";
        ArrayList<ImmutableMap> fields = new ArrayList<ImmutableMap>();
        fields.add(ImmutableMap.of((Object)"name", (Object)"text", (Object)"xpath", (Object)"."));
        Iterator iterator = JulieXMLTools.constructRowIterator((VTDNav)nav, (String)forEachXpath, fields, (String)xmlFileName);
        while (iterator.hasNext()) {
            texts.add((String)((Map)iterator.next()).get("text"));
        }
        return texts;
    }

    static Map<String, String[]> mapAttribute2Text(String xmlFileName, VTDNav nav, String forEachXpath, String attributeXpath) {
        HashMap<String, String[]> attribute2text = new HashMap<String, String[]>();
        String text = "text";
        String attribute = "attribute";
        ArrayList<ImmutableMap> fields = new ArrayList<ImmutableMap>();
        fields.add(ImmutableMap.of((Object)"name", (Object)"text", (Object)"xpath", (Object)"."));
        fields.add(ImmutableMap.of((Object)"name", (Object)"attribute", (Object)"xpath", (Object)attributeXpath));
        Iterator iterator = JulieXMLTools.constructRowIterator((VTDNav)nav, (String)forEachXpath, fields, (String)xmlFileName);
        while (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            String attributeValue = (String)row.get("attribute");
            if (attribute2text.containsKey(attributeValue)) {
                String[] old = (String[])attribute2text.get(attributeValue);
                String[] newOne = Arrays.copyOf(old, old.length + 1);
                newOne[old.length] = (String)row.get("text");
                attribute2text.put(attributeValue, newOne);
                continue;
            }
            attribute2text.put(attributeValue, new String[]{(String)row.get("text")});
        }
        return attribute2text;
    }

    static void readDocument(JCas jcas, VTDNav nav, String xmlFileName, boolean normalize) throws ParseException, IOException {
        Map<String, String[]> id2token = DTAFileReader.mapAttribute2Text(xmlFileName, nav, "/D-Spin/TextCorpus/tokens/token", "@ID");
        Map<String, String[]> id2lemma = DTAFileReader.mapAttribute2Text(xmlFileName, nav, "/D-Spin/TextCorpus/lemmas/lemma", "@tokenIDs");
        Map<String, String[]> id2pos = DTAFileReader.mapAttribute2Text(xmlFileName, nav, "/D-Spin/TextCorpus/POStags/tag", "@tokenIDs");
        Map<String, String[]> id2correction = normalize ? DTAFileReader.mapAttribute2Text(xmlFileName, nav, "/D-Spin/TextCorpus/orthography/correction[@operation='replace']", "@tokenIDs") : null;
        StringBuilder text = new StringBuilder();
        int sentenceStart = 0;
        for (String tokenIDs : DTAFileReader.getAttributeForEach(xmlFileName, nav, "/D-Spin/TextCorpus/sentences/sentence", "@tokenIDs")) {
            boolean first = true;
            for (String id : tokenIDs.split(" ")) {
                String tokenString = DTAFileReader.getEntry(xmlFileName, id, id2token, id2correction);
                if (tokenString.length() == 0) continue;
                String posString = DTAFileReader.getEntry(xmlFileName, id, id2pos);
                String lemmaString = DTAFileReader.getEntry(xmlFileName, id, id2lemma);
                if (first) {
                    first = false;
                } else if (!posString.equals("$,") && !posString.equals("$.")) {
                    text.append(" ");
                }
                int begin = text.length();
                text.append(tokenString);
                int end = text.length();
                Token token = new Token(jcas, begin, end);
                token.setComponentId(COMPONENT_ID);
                Lemma lemma = new Lemma(jcas, begin, end);
                lemma.setValue(lemmaString);
                lemma.addToIndexes();
                token.setLemma(lemma);
                STTSPOSTag tag = new STTSPOSTag(jcas, begin, end);
                tag.setValue(posString);
                tag.setBegin(begin);
                tag.setEnd(end);
                tag.setComponentId(COMPONENT_ID);
                tag.addToIndexes();
                FSArray postags = new FSArray(jcas, 1);
                postags.set(0, (FeatureStructure)tag);
                token.setPosTag(postags);
                token.addToIndexes();
            }
            Sentence sentence = new Sentence(jcas, sentenceStart, text.length());
            sentence.setComponentId(COMPONENT_ID);
            sentence.addToIndexes();
            text.append("\n");
            sentenceStart = text.length();
        }
        jcas.setDocumentText(text.subSequence(0, text.length() - 1).toString());
    }

    static void readHeader(JCas jcas, VTDNav nav, String xmlFileName, boolean xpath2017) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Header h = new Header(jcas);
        String titleXpath = xpath2017 ? "/D-Spin/MetaData/source/cmd:CMD/cmd:Components/cmdp:teiHeader/cmdp:fileDesc/cmdp:titleStmt/cmdp:title" : "/D-Spin/MetaData/source/CMD/Components/teiHeader/fileDesc/titleStmt/title";
        Map<String, String[]> titles = DTAFileReader.mapAttribute2Text(xmlFileName, nav, titleXpath, "@type");
        h.setTitle(DTAFileReader.getEntry(xmlFileName, "main", titles));
        Object[] subTitle = titles.get("sub");
        if (subTitle != null) {
            h.setSubtitle(NEW_LINE_JOINER.join(subTitle));
        }
        boolean moreThanOne = false;
        for (String volume : DTAFileReader.getAttributeForEach(xmlFileName, nav, titleXpath + "[@type='volume']", "@n")) {
            if (moreThanOne) {
                throw new IllegalArgumentException(xmlFileName + " has more than one volume!");
            }
            h.setVolume(volume);
            moreThanOne = true;
        }
        h.setAuthors(DTAFileReader.getPersons(jcas, nav, xmlFileName, PersonType.author, xpath2017));
        h.setEditors(DTAFileReader.getPersons(jcas, nav, xmlFileName, PersonType.editor, xpath2017));
        String classXpath = xpath2017 ? "/D-Spin/MetaData/source/cmd:CMD/cmd:Components/cmdp:teiHeader/cmdp:profileDesc/cmdp:textClass/cmdp:classCode" : "/D-Spin/MetaData/source/CMD/Components/teiHeader/profileDesc/textClass/classCode";
        Map<String, String[]> classInfo = DTAFileReader.mapAttribute2Text(xmlFileName, nav, classXpath, "@scheme");
        h.setIsCoreCorpus(MappingService.isCoreCorpus(classInfo));
        FSArray classifications = MappingService.getClassifications(jcas, xmlFileName, classInfo);
        if (classifications == null) {
            throw new IllegalArgumentException(xmlFileName + " missing classification!");
        }
        h.setClassifications(classifications);
        Map<String, String[]> yearInfo = DTAFileReader.mapAttribute2Text(xmlFileName, nav, xpath2017 ? XPATH_YEAR_2017 : XPATH_YEAR_2016, "@type");
        String[] year = null;
        if (yearInfo.containsKey("creation")) {
            year = yearInfo.get("creation");
        } else if (yearInfo.containsKey("publication")) {
            year = yearInfo.get("publication");
        }
        if (year == null) {
            throw new IllegalArgumentException(xmlFileName + " has no creation/publication year!");
        }
        if (year.length > 1) {
            throw new IllegalArgumentException(xmlFileName + " has multiple creation/publication years!");
        }
        h.setYear(year[0]);
        String placeXpath = xpath2017 ? "/D-Spin/MetaData/source/cmd:CMD/cmd:Components/cmdp:teiHeader/cmdp:fileDesc/cmdp:sourceDesc/cmdp:biblFull/cmdp:publicationStmt/cmdp:pubPlace" : "/D-Spin/MetaData/source/CMD/Components/teiHeader/fileDesc/sourceDesc/biblFull/publicationStmt/pubPlace";
        List<String> publicationPlaces = DTAFileReader.getTexts(xmlFileName, nav, placeXpath);
        StringArray pubArray = new StringArray(jcas, publicationPlaces.size());
        for (int i = 0; i < publicationPlaces.size(); ++i) {
            pubArray.set(i, publicationPlaces.get(i));
        }
        pubArray.addToIndexes();
        h.setPublicationPlaces(pubArray);
        String publisherXpath = xpath2017 ? "/D-Spin/MetaData/source/cmd:CMD/cmd:Components/cmdp:teiHeader/cmdp:fileDesc/cmdp:sourceDesc/cmdp:biblFull/cmdp:publicationStmt/cmdp:publisher/cmdp:name" : "/D-Spin/MetaData/source/CMD/Components/teiHeader/fileDesc/sourceDesc/biblFull/publicationStmt/publisher/name";
        List<String> publisher = DTAFileReader.getTexts(xmlFileName, nav, publisherXpath);
        StringArray publisherArray = new StringArray(jcas, publisher.size());
        for (int i = 0; i < publisher.size(); ++i) {
            publisherArray.set(i, publisher.get(i));
        }
        publisherArray.addToIndexes();
        h.setPublishers(publisherArray);
        h.addToIndexes();
    }

    public void close() throws IOException {
    }

    public void getNext(CAS aCAS) throws CollectionException {
        try {
            JCas jcas = aCAS.getJCas();
            File file = this.inputFiles.get(this.counter);
            VTDNav nav = JulieXMLTools.getVTDNav((InputStream)new FileInputStream(file), (int)1024);
            String xmlFileName = file.getCanonicalPath();
            LOGGER.info("Reading file:" + this.counter + " - " + xmlFileName);
            if (!DTAFileReader.formatIsOk(xmlFileName, nav, this.format2017)) {
                LOGGER.info("Skipping file:" + this.counter + " - " + xmlFileName);
            } else {
                DTAFileReader.readDocument(jcas, nav, xmlFileName, this.normalize);
                DTAFileReader.readHeader(jcas, nav, xmlFileName, this.format2017);
                LOGGER.info("Read file:" + this.counter + " - " + xmlFileName);
            }
            ++this.counter;
        }
        catch (Exception e) {
            throw new CollectionException((Throwable)e);
        }
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.counter, this.inputFiles.size(), "entities")};
    }

    public boolean hasNext() throws IOException, CollectionException {
        return this.counter < this.inputFiles.size();
    }

    public void initialize() throws ResourceInitializationException {
        Object o2;
        String filename = (String)this.getConfigParameterValue(PARAM_INPUTFILE);
        Object o = this.getConfigParameterValue(PARAM_NORMALIZE);
        if (o != null) {
            this.normalize = (Boolean)o;
        }
        if ((o2 = this.getConfigParameterValue(PARAM_FORMAT_2017)) != null) {
            this.format2017 = (Boolean)o2;
        }
        LOGGER.info("Parameters: inputfile=" + filename + " normalize= " + this.normalize + " 2017format=" + this.format2017);
        File inputFile = new File(filename);
        if (!inputFile.exists()) {
            throw new IllegalArgumentException(filename + " does not exist!");
        }
        if (inputFile.isFile() && inputFile.getName().endsWith(".tcf.xml")) {
            this.inputFiles.add(inputFile);
        } else {
            File[] files = inputFile.listFiles();
            if (files == null) {
                throw new IllegalArgumentException("Unsure if " + filename + " is a directroy...");
            }
            for (File f : files) {
                if (!f.isFile() || !f.getName().endsWith(".tcf.xml")) continue;
                this.inputFiles.add(f);
            }
        }
        LOGGER.info("Input contains " + this.inputFiles.size() + " xml files.");
    }
}

