/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.dta.mapping;

import de.julielab.jcore.types.extensions.dta.DocumentClassification;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.uima.jcas.JCas;

public abstract class AbstractMapper {
    final String mainClassification;
    final String subClassification;
    final Map<String, Class<? extends DocumentClassification>> classification2class;
    final Class<? extends DocumentClassification> defaultClass;

    AbstractMapper(String mainClassification, String subClassification, Map<String, Class<? extends DocumentClassification>> classification2class) {
        this(mainClassification, subClassification, classification2class, null);
    }

    AbstractMapper(String mainClassification, String subClassification, Map<String, Class<? extends DocumentClassification>> classification2class, Class<? extends DocumentClassification> defaultClass) {
        this.mainClassification = "http://www.deutschestextarchiv.de/doku/klassifikation#" + mainClassification;
        this.subClassification = "http://www.deutschestextarchiv.de/doku/klassifikation#" + subClassification;
        this.classification2class = classification2class;
        this.defaultClass = defaultClass;
    }

    DocumentClassification getClassification(JCas jcas, String xmlFileName, Map<String, String[]> classInfo) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (classInfo.containsKey(this.mainClassification)) {
            if (classInfo.get(this.mainClassification).length != 1) {
                throw new IllegalArgumentException("More than 1 " + this.mainClassification + " classification in " + xmlFileName);
            }
            String mainClass = classInfo.get(this.mainClassification)[0];
            Class<? extends DocumentClassification> aClass = this.classification2class.get(mainClass);
            if (aClass == null) {
                if (this.defaultClass == null) {
                    throw new IllegalArgumentException(mainClass + " not supported in " + xmlFileName);
                }
                aClass = this.defaultClass;
            }
            Constructor<? extends DocumentClassification> constructor = aClass.getConstructor(JCas.class);
            DocumentClassification classification = constructor.newInstance(jcas);
            classification.setClassification(mainClass);
            if (classInfo.get(this.subClassification) != null) {
                if (classInfo.get(this.subClassification).length != 1) {
                    throw new IllegalArgumentException("More than 1 " + this.subClassification + " classification in " + xmlFileName);
                }
                String subClass = classInfo.get(this.subClassification)[0];
                classification.setSubClassification(subClass);
            }
            classification.addToIndexes();
            return classification;
        }
        return null;
    }
}

