/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.dta.mapping;

import de.julielab.jcore.reader.dta.mapping.AbstractMapper;
import de.julielab.jcore.reader.dta.mapping.DTAMapper;
import de.julielab.jcore.reader.dta.mapping.DWDS1Mapper;
import de.julielab.jcore.reader.dta.mapping.DWDS2Mapper;
import de.julielab.jcore.types.extensions.dta.DocumentClassification;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;

public abstract class MappingService {
    static final String CLASIFICATION = "http://www.deutschestextarchiv.de/doku/klassifikation#";
    private static final String CLASIFICATION_DTA_CORPUS = "http://www.deutschestextarchiv.de/doku/klassifikation#DTACorpus";
    private static final AbstractMapper[] mappers = new AbstractMapper[]{new DTAMapper(), new DWDS1Mapper(), new DWDS2Mapper()};

    public static FSArray getClassifications(JCas jcas, String xmlFileName, Map<String, String[]> classInfo) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ArrayList<DocumentClassification> classificationsList = new ArrayList<DocumentClassification>();
        for (AbstractMapper mapper : mappers) {
            DocumentClassification classification = mapper.getClassification(jcas, xmlFileName, classInfo);
            if (classification == null) continue;
            classificationsList.add(classification);
        }
        if (classificationsList.isEmpty()) {
            return null;
        }
        FeatureStructure[] classificationsArray = classificationsList.toArray(new FeatureStructure[classificationsList.size()]);
        FSArray classificationsFSArray = new FSArray(jcas, classificationsArray.length);
        classificationsFSArray.copyFromArray(classificationsArray, 0, 0, classificationsArray.length);
        classificationsFSArray.addToIndexes();
        return classificationsFSArray;
    }

    public static boolean isCoreCorpus(Map<String, String[]> classInfo) {
        return classInfo.containsKey(CLASIFICATION_DTA_CORPUS) && Arrays.asList((Object[])classInfo.get(CLASIFICATION_DTA_CORPUS)).contains("core");
    }
}

