/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.dta.util;

import de.julielab.jcore.reader.dta.DTAFileReader;
import de.julielab.jcore.types.Sentence;
import de.julielab.jcore.types.Token;
import de.julielab.jcore.types.extensions.dta.DocumentClassification;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.InvalidXMLException;

public class DTAUtils {
    public static CollectionReader getReader(String inputFile, boolean normalize, boolean format2017) throws InvalidXMLException, IOException, ResourceInitializationException {
        return CollectionReaderFactory.createReader(DTAFileReader.class, (Object[])new Object[]{"inputFile", inputFile, "normalize", normalize, "format2017", format2017});
    }

    public static boolean hasAnyClassification(JCas jcas, Class<?> ... classes) {
        for (DocumentClassification classification : jcas.getAnnotationIndex(DocumentClassification.type)) {
            for (Class<?> c : classes) {
                if (!c.isInstance(classification)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<List<String>> slidingSymetricWindow(JCas jcas, int windowPerSide) {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        for (Sentence sentence : jcas.getAnnotationIndex(Sentence.type)) {
            List tokens = JCasUtil.selectCovered(Token.class, (AnnotationFS)sentence);
            if (tokens.size() < windowPerSide * 2 + 1) continue;
            for (int i = windowPerSide; i < tokens.size() - windowPerSide; ++i) {
                ArrayList<String> inWindow = new ArrayList<String>(windowPerSide * 2 + 1);
                list.add(inWindow);
                for (int j = i - windowPerSide; j < i + windowPerSide + 1; ++j) {
                    inWindow.add(((Token)tokens.get(j)).getCoveredText());
                }
            }
        }
        return list;
    }
}

