/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.ew;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.lang3.tuple.Pair;

public class Encoder {
    public static byte[] encodeTextVectorPair(Pair<String, double[]> pair, ByteBuffer bb) throws IOException {
        return Encoder.encodeTextVectorPair((String)pair.getLeft(), (double[])pair.getRight(), bb);
    }

    public static byte[] encodeTextVectorPair(String text, double[] vector, ByteBuffer bb) throws IOException {
        byte[] textBytes = text.getBytes(StandardCharsets.UTF_8);
        int requiredBytes = 8 + textBytes.length + vector.length * 8;
        if (bb == null || bb.capacity() < requiredBytes) {
            bb = ByteBuffer.allocate(requiredBytes);
        }
        bb.position(0);
        bb.putInt(textBytes.length);
        bb.put(textBytes);
        bb.putInt(vector.length);
        for (double d : vector) {
            bb.putDouble(d);
        }
        byte[] output = bb.array();
        return Arrays.copyOf(output, bb.position());
    }
}

