/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.file.main;

import de.julielab.jcore.types.Date;
import de.julielab.jcore.types.pubmed.Header;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;

public class FileReader
extends CollectionReader_ImplBase {
    public static final String DIRECTORY_INPUT = "InputDirectory";
    public static final String FILENAME_AS_DOC_ID = "UseFilenameAsDocId";
    public static final String PUBLICATION_DATES_FILE = "PublicationDatesFile";
    public static final String ALLOWED_FILE_EXTENSIONS = "AllowedFileExtensions";
    private ArrayList<File> files;
    private int fileIndex;
    private boolean useFilenameAsDocId;
    private File publicationDatesFile;

    public void initialize() throws ResourceInitializationException {
        Boolean filenameAsDocId;
        File inputDirectory = new File(((String)this.getConfigParameterValue(DIRECTORY_INPUT)).trim());
        if (this.getConfigParameterValue(PUBLICATION_DATES_FILE) != null) {
            this.publicationDatesFile = new File(((String)this.getConfigParameterValue(PUBLICATION_DATES_FILE)).trim());
        }
        this.useFilenameAsDocId = (filenameAsDocId = (Boolean)this.getConfigParameterValue(FILENAME_AS_DOC_ID)) == null ? false : filenameAsDocId;
        String[] allowedExtensionsArray = (String[])this.getConfigParameterValue(ALLOWED_FILE_EXTENSIONS);
        final HashSet<String> allowedExtensions = new HashSet<String>();
        if (allowedExtensionsArray != null) {
            int i = 0;
            while (i < allowedExtensionsArray.length) {
                String allowedExtension = allowedExtensionsArray[i];
                allowedExtensions.add(allowedExtension);
                ++i;
            }
        }
        this.fileIndex = 0;
        if (!inputDirectory.exists() || !inputDirectory.isDirectory()) {
            throw new ResourceInitializationException("directory_not_found", new Object[]{DIRECTORY_INPUT, this.getMetaData().getName(), inputDirectory.getPath()});
        }
        this.files = new ArrayList();
        File[] f = inputDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (allowedExtensions.isEmpty()) {
                    return true;
                }
                String extension = name.substring(name.lastIndexOf(46) + 1);
                return allowedExtensions.contains(extension);
            }
        });
        int i = 0;
        while (i < f.length) {
            if (!f[i].isDirectory()) {
                this.files.add(f[i]);
            }
            ++i;
        }
    }

    public boolean hasNext() {
        return this.fileIndex < this.files.size();
    }

    public void getNext(CAS aCAS) throws IOException, CollectionException {
        JCas jcas;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException e) {
            throw new CollectionException((Throwable)e);
        }
        File file = this.files.get(this.fileIndex++);
        String text = FileUtils.readFileToString((File)file, (String)"UTF-8");
        jcas.setDocumentText(text);
        if (this.useFilenameAsDocId) {
            int extUnderScoreIndex;
            String filename = file.getName();
            int extDotIndex = filename.lastIndexOf(46);
            if (extDotIndex > 0) {
                filename = filename.substring(0, extDotIndex);
            }
            if ((extUnderScoreIndex = filename.lastIndexOf(95)) > 0) {
                filename = filename.substring(0, extUnderScoreIndex);
            }
            Header header = new Header(jcas);
            header.setDocId(filename);
            this.addDateForID(header, jcas, filename);
            header.addToIndexes();
        }
    }

    private void addDateForID(Header header, JCas jCas, String id) {
        if (this.publicationDatesFile != null && this.publicationDatesFile.exists() && this.publicationDatesFile.isFile()) {
            try {
                BufferedReader br = new BufferedReader(new java.io.FileReader(this.publicationDatesFile));
                String line = "";
                while ((line = br.readLine()) != null) {
                    String[] tokens = line.split("\\s+");
                    if (tokens.length != 2 || !tokens[0].equals(id) || tokens[1].length() != 7) continue;
                    Date pubDate = new Date(jCas);
                    int year = 0;
                    int month = 0;
                    try {
                        year = Integer.parseInt(tokens[1].substring(0, 4));
                        month = Integer.parseInt(tokens[1].substring(5));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (month != 0) {
                        pubDate.setMonth(month);
                    }
                    if (year != 0) {
                        pubDate.setYear(year);
                        pubDate.addToIndexes();
                    }
                    break;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void close() throws IOException {
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.fileIndex, this.files.size(), "entities")};
    }
}

